% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{build_reg_model}
\alias{build_reg_model}
\title{Build a generic regression model model}
\usage{
build_reg_model(
  df,
  outcome,
  predictors,
  covariates = c(),
  modality = "linear",
  verbose = FALSE
)
}
\arguments{
\item{df}{data.frame containing the data set}

\item{outcome}{character denoting column with the outcome of interest}

\item{predictors}{character vector denoting columns with independent variables of interest}

\item{covariates}{character vector denoting columns with independent variables not of interest.
Covariates are mathematically identical to predictors but will be ignored in reporting}

\item{modality}{character designating type. Currently limited to 'linear' and 'logistic'.}

\item{verbose}{logical. TRUE activates printout messages}
}
\value{
A regression model of linear or logistic type
}
\description{
Build a generic regression model from data and meta-parameters.
Currently only available for linear and logistic types.
}
\examples{
mod <- build_reg_model(data.frame('outcome' = c(1,2), 'pred' = c(3,4)), 'outcome', c('pred'))

}
\author{
J. Peter Marquardt
}
