#' List of the day count conventions implemented.
#'
#' @docType data
#'
#' @usage data(List.DCC)
#'
#' @format A data frame with 16 rows and 3 variables:
#' \describe{
#'   \item{DCC}{Identifier.}
#'   \item{DCC.Name}{Names of the day count convention.}
#'   \item{DCC.Reference}{Reference.}
#' }
#'
#' @references
#' \enumerate{
#'   \item{Banking Federation of the European Union (EBF), 2004, Master Agreement for Financial Transactions - Supplement to the Derivatives Annex - Interest Rate Transactions.}
#'   \item{Caputo Silva, Anderson, Lena Oliveira de Carvalho, and Octavio Ladeira de Medeiros, 2010, \emph{Public Debt: The Brazilian Experience} (National Treasury Secretariat and World Bank, Brasilia, BR).}
#'   \item{International Capital Market Association (ICMA), 2010, Rule 251 Accrued Interest Calculation - Excerpt from ICMA's Rules and Recommendations.}
#'   \item{Investment Industry Association of Canada (IIAC), 2018, Canadian Conventions in Fixed Income Markets - A Reference Document of Fixed Income Securities Formulas and Practices; Release: 1.3.}
#'   \item{International Swaps and Derivatives Association (ISDA), Inc., 1998, "EMU and Market Conventions: Recent Developments".}
#'   \item{International Swaps and Derivatives Association (ISDA), 2006, Inc., \emph{2006 ISDA Definitions.}, New York.}
#'   \item{Itau Unibanco S.A., 2017, Brazilian Sovereign Fixed Income and Foreign Exchange Markets - Handbook (First Edition).}
#'   \item{Krgin, Dragomir, 2002, The Handbook of Global Fixed Income Calculations. (Wiley, New York).}
#'   \item{Mayle, Jan, 1993, Standard Securities Calculation Methods: Fixed Income Securities Formulas for Price, Yield, and Accrued Interest, volume 1, New York: Securities Industry Association, third edition.}
#'   \item{Municipal Securities Rulemaking Board (MSRB), 2017, MSRB Rule Book, Washington, DC: Municipal Securities Rulemaking Board.}
#'   \item{SWX Swiss Exchange and D. Christie, 2003, "Accrued Interest & Yield Calculations and Determination of Holiday Calendars".}
#' }
#'
#' @keywords datasets
#'
"List.DCC"
