\name{stateTransition}
\Rdversion{1.1}
\alias{stateTransition}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Performs a transition to the next state
}
\description{
Calculates the next state in a supplied network for a given current state
}
\usage{
stateTransition(network, state)
}
\arguments{
  \item{network}{
	A network structure of class \code{BooleanNetwork}. These networks can be read from files by \code{\link{loadNetwork}} or generated by \code{\link{generateRandomNKNetwork}}.
}
  \item{state}{
	The current state of the network, encoded as a vector with one 0-1 element for each gene.
}
}

\value{
	The subsequent state of the network, encoded as a vector with one 0-1 element for each gene.}
\seealso{
\code{\link{loadNetwork}}, \code{\link{generateRandomNKNetwork}}
}
\examples{
library(BoolNet)

# load example data
data(cellcycle)

# calculate a state transition
print(stateTransition(net,c(1,1,1,1,1,1,1,1,1,1)))
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{state transition
	Boolean network
	transition
	state}
