% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_raster_sim.R
\name{random_raster_sim}
\alias{random_raster_sim}
\title{Stochastic neutral landscape model}
\usage{
random_raster_sim(x)
}
\arguments{
\item{x}{A SpatRaster object.}
}
\value{
A SpatRaster object with boundary elements.
}
\description{
Simulates a spatially stochastic neutral landscape of the same extent and resolution as the input
raster, with the same distribution of values.
}
\examples{
data(grassland)
grassland <- terra::rast(grassland_matrix, crs = grassland_crs)
terra::ext(grassland) <- grassland_ext

simulation <- random_raster_sim(grassland)
terra::plot(simulation)

}
\references{
James, P. M. A., Fleming, R.A., & Fortin, M.-J. (2010) Identifying significant scale-specific spatial boundaries using wavelets and null models: Spruce budworm defoliation in Ontario, Canada as a case study. Landscape Ecology, 6, 873-887.
}
\author{
Amy Luo
}
