% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelection.R, R/summaryBranchGLMVS.R
\name{plot.BranchGLMVS}
\alias{plot.BranchGLMVS}
\alias{plot.summary.BranchGLMVS}
\title{Plot Method for summary.BranchGLMVS and BranchGLMVS objects}
\usage{
\method{plot}{BranchGLMVS}(x, ptype = "both", marx = 7, addLines = TRUE, type = "b", ...)

\method{plot}{summary.BranchGLMVS}(x, ptype = "both", marx = 7, addLines = TRUE, type = "b", ...)
}
\arguments{
\item{x}{a \code{summary.BranchGLMVS} or \code{BranchGLMVS} object.}

\item{ptype}{the type of plot to produce, look at details for more explanation.}

\item{marx}{value used to determine how large to make margin of x-axis, this is 
only for the "variables" plot. If variable names are cut-off, consider increasing this 
from the default value of 7.}

\item{addLines}{logical value to indicate whether or not to add black lines to 
separate the models for ptype = "variables". This is typically useful for smaller 
amounts of models, but can be annoying if there are many models.}

\item{type}{what type of plot to draw for the "metrics" plot, see more details 
at \link{par}.}

\item{...}{arguments passed to the generic plot and image methods.}
}
\value{
This only produces plots, nothing is returned.
}
\description{
Plot Method for summary.BranchGLMVS and BranchGLMVS objects
}
\details{
The different values for ptype are as follows
\itemize{
 \item "metrics" for a plot that displays the metric values ordered by rank
 \item "variables" for a plot that displays which variables are in each of the top models
 \item "both" for both plots
}
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", bestmodels = 10, 
showprogress = FALSE)
VS

## Getting summary of the process
Summ <- summary(VS)
Summ

## Plotting the BIC of the best models
plot(Summ, type = "b")

}
