% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLMTable.R
\name{Cindex}
\alias{Cindex}
\alias{AUC}
\alias{Cindex.numeric}
\alias{Cindex.BranchGLM}
\alias{Cindex.BranchGLMROC}
\title{Cindex/AUC}
\usage{
Cindex(object, ...)

AUC(object, ...)

\method{Cindex}{numeric}(object, y, ...)

\method{Cindex}{BranchGLM}(object, ...)

\method{Cindex}{BranchGLMROC}(object, ...)
}
\arguments{
\item{object}{a \code{BranchGLM} object, a \code{BranchGLMROC} object, or a numeric vector.}

\item{...}{further arguments passed to other methods.}

\item{y}{Observed values, can be a numeric vector of 0s and 1s, a two-level
factor vector, or a logical vector.}
}
\value{
A number corresponding to the c-index/AUC.
}
\description{
Calculates the c-index/AUC.
}
\details{
Uses trapezoidal rule to calculate AUC when given a BranchGLMROC object and
uses Mann-Whitney U to calculate it otherwise. The trapezoidal rule method is less accurate,
so the two methods may give different results.
}
\examples{
Data <- ToothGrowth
Fit <- BranchGLM(supp ~ ., data = Data, family = "binomial", link = "logit")
Cindex(Fit)
AUC(Fit)
}
