% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BullsEyeR.R
\name{createDTM}
\alias{createDTM}
\title{Create Document term Matrix}
\usage{
createDTM(ds, spvar = 0.99, myStopWords = NULL, stemvar = 0)
}
\arguments{
\item{ds}{a character vector of text documents}

\item{spvar}{a sparsity variable which defaults to 0.99}

\item{myStopWords}{a character vector of custom stop words which defaults to NULL}

\item{stemvar}{a variable indicating stemming to be performed or not which defaults to '0' meaning no stemming}
}
\value{
A Document Term Matrix.
}
\description{
The function createDTM creates a document term matrix after preprocessing and removal of stop words.
}
\examples{
\dontrun{
# Run it and see for yourself
}
data.tmp<-read.csv(system.file("ext", "testdata.csv", package="BullsEyeR"))
ds<-as.character(data.tmp$Story[1:2])
stopwords<-c("sallin","hannah","company","number","started","unlike")
createDTM(ds=ds,spvar=0.99,myStopWords=stopwords,stemvar=0)
}
