% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-setGeneric.R, R/BuyseRes_get.R
\docType{methods}
\name{getSurvival}
\alias{getSurvival}
\alias{BuyseRes-getSurvival}
\alias{getSurvival}
\alias{getSurvival,BuyseRes-method}
\title{Extract the Survival and Survival Jumps}
\usage{
getSurvival(object, type = NULL, endpoint = NULL, strata = NULL,
  unlist = TRUE, trace = TRUE)

\S4method{getSurvival}{BuyseRes}(object, type = NULL, endpoint = NULL,
  strata = NULL, unlist = TRUE, trace = TRUE)
}
\arguments{
\item{object}{an \R object of class \code{\linkS4class{BuyseRes}}, i.e., output of \code{\link{BuyseTest}}}

\item{type}{[character vector] the type of survival to be output. See details.}

\item{endpoint}{[integer/character vector] the endpoint for which the survival should be output.}

\item{strata}{[integer/character vector] the strata for which the survival should be output.}

\item{unlist}{[logical] should the structure of the output be simplified when possible.}

\item{trace}{[logical] should a message be printed to explain what happened
when the function returned \code{NULL}.}

\item{...}{not used. For compatibility with the generic method.}
}
\description{
Extract the survival and survival jumps.
}
\details{
The argument \code{type} can take any of the following values:
\itemize{
\item \code{"survTimeC"}: survival at the event times for the observations of the control arm.
\item \code{"survTimeT"}: survival at the event times for the observations of the treatment arm.
\item \code{"survJumpC"}: survival at the jump times for the survival model in the control arm.
\item \code{"survJumpT"}: survival at the time times for the survival model in the treatment arm.
\item \code{"lastSurv"}: survival at the last event time.
}
}
\keyword{BuyseRes-method}
\keyword{get}
