if(FALSE){
    library(testthat)
    library(BuyseTest)
}

context("Check BuyseTest without strata")

## * Settings
n.patients <- c(90,100)
BuyseTest.options(check = FALSE,
                  keep.pairScore = TRUE,
                  method.inference = "none",
                  trace = 0)

## * Simulated data
set.seed(10)
dt.sim <- simBuyseTest(n.T = n.patients[1],
                       n.C = n.patients[2],
                       argsBin = list(p.T = c(0.5,0.75)),
                       argsCont = list(mu.T = 1:3, sigma.T = rep(1,3)),
                       argsTTE = list(rates.T = 1:3, rates.Censor = rep(1,3)))
## butils::object2script(dt.sim)

dtS.sim <- rbind(cbind(dt.sim, strata = 1),
                 cbind(dt.sim, strata = 2),
                 cbind(dt.sim, strata = 3))


## * Binary endpoint
## ** No strata
test_that("BuyseTest - binary (no strata)", {
    BT.bin <- BuyseTest(Treatment ~ bin(toxicity1),
                        data = dt.sim)
    
    BT2 <- BuyseTest(data = dt.sim,
                     endpoint = "toxicity1",
                     treatment = "Treatment",
                     type = "bin")
    
    ## *** test against fixed value
    test <- list(favorable = as.double(BT.bin@count.favorable),
                 unfavorable = as.double(BT.bin@count.unfavorable),
                 neutral = as.double(BT.bin@count.neutral),
                 uninf = as.double(BT.bin@count.uninf),
                 netChange = as.double(BT.bin@Delta.netChance),
                 winRatio = as.double(BT.bin@Delta.winRatio)
                 )

    GS <- list(favorable = c(2856) ,
               unfavorable = c(1716) ,
               neutral = c(4428) ,
               uninf = c(0) ,
               netChange = c(0.126667) ,
               winRatio = c(1.664336) )
    ## butils::object2script(test, digit = 6)

    expect_equal(test, GS, tol = 1e-6, scale = 1)
    expect_equal(BT.bin,BT2)

    ## fisherP <- fisher.test(table(dt.sim$toxicity1,dt.sim$Treatment))

    ## *** count pairs
    tableS <- summary(BT.bin, print = FALSE, percentage = FALSE)$table
    dt.tableS <- as.data.table(tableS)[strata == "global"]
    expect_equal(dt.tableS[,n.total],
                 unname(dt.tableS[,n.favorable + n.unfavorable + n.neutral + n.uninf])
                 )
})

## ** Strata
test_that("BuyseTest - binary (strata)", {

    BT.bin <- BuyseTest(Treatment ~ bin(toxicity1) + strata,
                        data = dtS.sim)

    tableS <- summary(BT.bin, print = FALSE, percentage = FALSE)$table
    dt.tableS <- as.data.table(tableS)
    
    ## *** count pairs
    expect_equal(dt.tableS[,n.total],
                 unname(dt.tableS[,n.favorable + n.unfavorable + n.neutral + n.uninf]
                 ))
    expect_equal(dt.tableS[,n.total], c(27000,9000,9000,9000))
    expect_equal(dt.tableS[,n.favorable], c(8568, 2856, 2856, 2856))
    expect_equal(dt.tableS[,n.unfavorable], c(5148, 1716, 1716, 1716))
    expect_equal(dt.tableS[,n.neutral], c(13284, 4428, 4428, 4428))
    expect_equal(dt.tableS[,n.uninf], c(0, 0, 0, 0))

    ## *** test summary statistic
    expect_equal(dt.tableS[,delta], c(0.1266667, 0.1266667, 0.1266667, 0.1266667), tol = 1e-6)
    expect_equal(dt.tableS[,Delta], c(0.1266667, NA, NA, NA), tol = 1e-6)
})

## * Continuous endpoint
## ** No strata
test_that("BuyseTest - continuous (no strata)", {
    BT.cont <- BuyseTest(Treatment ~ cont(score1, 1) + cont(score2, 0),
                         data = dt.sim)
    
    BT2 <- BuyseTest(data = dt.sim,
                     endpoint = c("score1","score2"),
                     treatment = "Treatment",
                     type = c("cont","cont"),
                     threshold = c(1,0)
                     )
    
    ## *** test against fixed value    
    test <- list(favorable = as.double(BT.cont@count.favorable),
                 unfavorable = as.double(BT.cont@count.unfavorable),
                 neutral = as.double(BT.cont@count.neutral),
                 uninf = as.double(BT.cont@count.uninf),
                 netChange = as.double(BT.cont@Delta.netChance),
                 winRatio = as.double(BT.cont@Delta.winRatio)
                 )
    GS <- list(favorable = c(1562, 2336) ,
               unfavorable = c(2690, 2412) ,
               neutral = c(4748, 0) ,
               uninf = c(0, 0) ,
               netChange = c(-0.125333, -0.133778) ,
               winRatio = c(0.580669, 0.764014) )
    ## butils::object2script(test, digit = 6)

    expect_equal(test, GS, tol = 1e-6, scale = 1)
    expect_equal(BT.cont,BT2)

    ## *** count pairs
    tableS <- summary(BT.cont, print = FALSE, percentage = FALSE)$table
    dt.tableS <- as.data.table(tableS)[strata == "global"]
    expect_equal(dt.tableS[,n.total],
                 unname(dt.tableS[, n.favorable + n.unfavorable + n.neutral + n.uninf]
                 ))
})

## ** Strata
test_that("BuyseTest - continuous (strata)", {

    BT.cont <- BuyseTest(Treatment ~ cont(score1, 1) + cont(score2, 0) + strata,
                         data = dtS.sim)

    tableS <- summary(BT.cont, print = FALSE, percentage = FALSE)$table
    dt.tableS <- as.data.table(tableS)

        ## *** count pairs
    expect_equal(dt.tableS[,n.total],
                 unname(dt.tableS[,n.favorable + n.unfavorable + n.neutral + n.uninf]
                 ))
    expect_equal(dt.tableS[,n.total], c(27000, 9000, 9000, 9000, 14244, 4748, 4748, 4748))
    expect_equal(dt.tableS[,n.favorable], c(4686, 1562, 1562, 1562, 7008, 2336, 2336, 2336))
    expect_equal(dt.tableS[,n.unfavorable], c(8070, 2690, 2690, 2690, 7236, 2412, 2412, 2412))
    expect_equal(dt.tableS[,n.neutral], c(14244, 4748, 4748, 4748, 0, 0, 0, 0))
    expect_equal(dt.tableS[,n.uninf], c(0, 0, 0, 0, 0, 0, 0, 0))

    ## *** test summary statistic
    expect_equal(dt.tableS[,delta], c(-0.1253333, -0.1253333, -0.1253333, -0.1253333, -0.0084444, -0.0084444, -0.0084444, -0.0084444), tol = 1e-6)
    expect_equal(dt.tableS[,Delta], c(-0.1253333, NA, NA, NA, -0.1337778, NA, NA, NA), tol = 1e-6)
})


## * Time to event endpoint
## ** No strata - same endpoint
## for(method in c("Gehan","Peron")){ ## method <- "Peron"
for(method in c("Gehan","Peron")){ ## method <- "Peron"
    test_that(paste0("BuyseTest - tte (same, ",method,", no strata)"),{ 

        BT.tte <- BuyseTest(Treatment ~ tte(eventtime1, 1, status1) + tte(eventtime1, 0.5, status1) + tte(eventtime1, 0.25, status1),
                            data = dt.sim,
                            method.tte = method,
                            correction.uninf = FALSE
                            )
        
        BT2 <- BuyseTest(data = dt.sim,
                         endpoint = c("eventtime1","eventtime1","eventtime1"),
                         censoring = c("status1","status1","status1"),
                         treatment = "Treatment",
                         type = c("tte","tte","tte"),
                         threshold = c(1,0.5,0.25),
                         method.tte = method,
                         correction.uninf = FALSE
                         )
    
        ## *** test against fixed value
        test <- list(favorable = as.double(BT.tte@count.favorable),
                     unfavorable = as.double(BT.tte@count.unfavorable),
                     neutral = as.double(BT.tte@count.neutral),
                     uninf = as.double(BT.tte@count.uninf),
                     netChange = as.double(BT.tte@Delta.netChance),
                     winRatio = as.double(BT.tte@Delta.winRatio)
                     )
        if(method == "Gehan"){
            GS <- list(favorable = c(353, 649, 524) ,
                       unfavorable = c(394, 601, 490) ,
                       neutral = c(1931, 1294, 789) ,
                       uninf = c(6322, 5709, 5200) ,
                       netChange = c(-0.0045556, 0.0007778, 0.0045556) ,
                       winRatio = c(0.8959391, 1.0070352, 1.0276094) )
            ## butils::object2script(test, digit = 8)
            
        }else if(method == "Peron"){
            GS <- list(favorable = c(2443.46245011, 979.48638589, 629.90517919) ,
                       unfavorable = c(1395.18398457, 1113.5745081, 723.5751254) ,
                       neutral = c(5161.35356532, 3068.29267133, 1714.81236674) ,
                       uninf = c(0, 0, 0) ,
                       netChange = c(0.11647539, 0.1015767, 0.09116893) ,
                       winRatio = c(1.751355, 1.3643995, 1.25384768) )
        }

        expect_equal(test, GS, tolerance = 1e-6, scale = 1)
        expect_equal(BT.tte, BT2)

        ## *** count pairs
        tableS <- summary(BT.tte, print = FALSE, percentage = FALSE)$table
        dt.tableS <- as.data.table(tableS)[strata == "global"]
        expect_equal(dt.tableS[,n.total],
                     unname(dt.tableS[,n.favorable + n.unfavorable + n.neutral + n.uninf]),
                     tolerance = 1e-1, scale = 1) ## inexact for Peron
                     
    })
}

## ** No strata - different endpoints
## for(method in c("Gehan","Peron")){ ## method <- "Peron"
for(method in c("Gehan","Peron")){ ## method <- "Peron"
    test_that(paste0("BuyseTest - tte (different, ",method,", no strata)"),{ 
    
        BT.tte <- BuyseTest(Treatment ~ tte(eventtime1, 1, status1) + tte(eventtime2, 0.5, status2) + tte(eventtime3, 0.25, status3),
                            data = dt.sim, method.tte = method,
                            correction.uninf = FALSE)

        BT2 <- BuyseTest(data = dt.sim,
                         endpoint = c("eventtime1","eventtime2","eventtime3"),
                         censoring = c("status1","status2","status3"),
                         treatment = "Treatment",
                         type = c("tte","tte","tte"),
                         threshold = c(1,0.5,0.25),
                         method.tte = method,
                         correction.uninf = FALSE
                         )
    
        ## *** test against fixed value
        test <- list(favorable = as.double(BT.tte@count.favorable),
                     unfavorable = as.double(BT.tte@count.unfavorable),
                     neutral = as.double(BT.tte@count.neutral),
                     uninf = as.double(BT.tte@count.uninf),
                     netChange = as.double(BT.tte@Delta.netChance),
                     winRatio = as.double(BT.tte@Delta.winRatio)
                     )
        if(method == "Gehan"){
            GS <- list(favorable = c(353, 666, 924) ,
                       unfavorable = c(394, 756, 487) ,
                       neutral = c(1931, 578, 200) ,
                       uninf = c(6322, 6253, 5220) ,
                       netChange = c(-0.00455556, -0.01455556, 0.034) ,
                       winRatio = c(0.89593909, 0.88608696, 1.18692731) )
            ## butils::object2script(test, digit = 8)
            
        }else if(method == "Peron"){
            GS <- list(favorable = c(2443.46245011, 1988.35190003, 825.36704825) ,
                       unfavorable = c(1395.18398457, 1845.87475171, 310.74049374) ,
                       neutral = c(5161.35356532, 1303.03523326, 188.63749106) ,
                       uninf = c(0, 24.09168032, 2.38188053) ,
                       netChange = c(0.11647539, 0.13230618, 0.18948691) ,
                       winRatio = c(1.751355, 1.36739711, 1.48014599) )
        }
        
        expect_equal(test, GS, tolerance = 1e-6, scale = 1)
        expect_equal(BT.tte,BT2)

        ## *** count pairs
        tableS <- summary(BT.tte, print = FALSE, percentage = FALSE)$table
        dt.tableS <- as.data.table(tableS)[strata == "global"]
        expect_equal(dt.tableS[,n.total],
                     unname(dt.tableS[,n.favorable + n.unfavorable + n.neutral + n.uninf]),
                     tolerance = 1e-1, scale = 1) ## inexact for Peron
    })
}

## ** Strata - same endpoint
if(FALSE){
method <- "Peron"
test_that(paste0("BuyseTest - tte (same, ",method,", strata)"),{ 
    
        BT.tte <- BuyseTest(Treatment ~ tte(eventtime1, 1, status1) + tte(eventtime1, 0.5, status1) + tte(eventtime1, 0.25, status1) + strata,
                            data = dtS.sim, method.tte = method)


        ## *** test against fixed value
        test <- list(favorable = as.double(BT.tte@count.favorable),
                     unfavorable = as.double(BT.tte@count.unfavorable),
                     neutral = as.double(BT.tte@count.neutral),
                     uninf = as.double(BT.tte@count.uninf),
                     netChange = as.double(BT.tte@Delta.netChance),
                     winRatio = as.double(BT.tte@Delta.winRatio)
                     )

        GS <- list(favorable = c(2443.4624501, 2443.4624501, 2443.4624501, 979.4863859, 979.4863859, 979.4863859, 629.9051792, 629.9051792, 629.9051792) ,
                   unfavorable = c(1395.1839846, 1395.1839846, 1395.1839846, 1113.5745081, 1113.5745081, 1113.5745081, 723.5751254, 723.5751254, 723.5751254) ,
                   neutral = c(1931, 1931, 1931, 1294, 1294, 1294, 789, 789, 789) ,
                   uninf = c(3230.3535653, 3230.3535653, 3230.3535653, 1774.2926713, 1774.2926713, 1774.2926713, 925.8123667, 925.8123667, 925.8123667) ,
                   netChange = c(0.1164754, 0.1015767, 0.0911689) ,
                   winRatio = c(1.751355, 1.3643995, 1.2538477) )

        expect_equal(GS, test, tol = 1e-6, scale = 1)
        
        ## *** same result for each pair
        tableS <- summary(BT.tte, print = FALSE, percentage = FALSE)$table
        expect_equal(tableS[tableS$strata=="1","Delta"],tableS[tableS$strata=="2","Delta"])
        expect_equal(tableS[tableS$strata=="1","Delta"],tableS[tableS$strata=="3","Delta"])
        expect_equal(tableS[tableS$strata=="1","Delta"],tableS[tableS$strata=="3","Delta"])
        
        ## *** count pairs
        dt.tableS <- as.data.table(tableS)[strata == "global"]
        expect_equal(dt.tableS[,n.total],
                     unname(dt.tableS[,n.favorable + n.unfavorable + n.neutral + n.uninf]),
                     tolerance = 1e-1, scale = 1) ## inexact for Peron
})
}

## * Mixed endpoints 
## for(method in c("Gehan","Peron")){ ## method <- "Peron"
for(method in c("Gehan")){ ## method <- "Peron"
    test_that(paste0("BuyseTest - mixed (",method,", no strata)"),{ 
    
        BT.mixed <- BuyseTest(Treatment ~ tte(eventtime1, 0.5, status1) + cont(score1, 1) + bin(toxicity1) + tte(eventtime1, 0.25, status1) + cont(score1, 0.5),
                              data = dt.sim, method.tte = method)

        BT2 <- BuyseTest(data=dt.sim,
                         endpoint=c("eventtime1","score1","toxicity1","eventtime1","score1"),
                         censoring=c("status1",NA,NA,"status1",NA),
                         treatment="Treatment",
                         type=c("timeToEvent","continuous","binary","timeToEvent","continuous"),
                         threshold=c(0.5,1,NA,0.25,0.5),
                         method.tte=method)
  
        ## *** test against fixed value
        test <- list(favorable = as.double(BT.mixed@count.favorable),
                     unfavorable = as.double(BT.mixed@count.unfavorable),
                     neutral = as.double(BT.mixed@count.neutral),
                     uninf = as.double(BT.mixed@count.uninf),
                     netChange = as.double(BT.mixed@Delta.netChance),
                     winRatio = as.double(BT.mixed@Delta.winRatio)
                     )
        if(method == "Gehan"){
            GS <- list(favorable = c(1002, 1294, 1175, 146, 334) ,
                       unfavorable = c(995, 1966, 714, 123, 411) ,
                       neutral = c(1294, 3743, 1854, 186, 840) ,
                       uninf = c(5709, 0, 0, 1399, 0) ,
                       netChange = c(0.00077778, -0.07388889, -0.02266667, -0.02011111, -0.02866667) ,
                       winRatio = c(1.00703518, 0.77541371, 0.9444898, 0.95234334, 0.93870278) )
            ## butils::object2script(test, digit = 8)
            
        }else if(method == "Peron"){
            GS <- list(favorable = c(3422.94883599, 523.83682056, 486.58403996, 179.36802198, 84.40050237) ,
                       unfavorable = c(2508.75849267, 940.43278022, 311.753946, 189.11524727, 118.87398395) ,
                       neutral = c(1294, 1604.02307056, 805.6850846, 186, 233.92732904) ,
                       uninf = c(1774.29267133, 0, 0, 251.20181536, 0) ,
                       netChange = c(0.1015767, 0.05528826, 0.07471383, 0.07363081, 0.06980042) ,
                       winRatio = c(1.3643995, 1.14426407, 1.17879135, 1.16776382, 1.15439024) )
        }
        
        expect_equal(test, GS, tolerance = 1e-6, scale = 1)
        expect_equal(BT.mixed,BT2)

        ## *** count pairs
        tableS <- summary(BT.mixed, print = FALSE, percentage = FALSE)$table
        dt.tableS <- as.data.table(tableS)[strata == "global"]
        expect_equal(dt.tableS[,n.total],
                     unname(dt.tableS[,n.favorable + n.unfavorable + n.neutral + n.uninf])
                     )

    })
}


## * dataset [save]
## dt.sim <- data.table("Treatment" = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), 
           ## "toxicity1" = c(1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0), 
           ## "toxicity2" = c(1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), 
           ## "score1" = c(1.42551309377198, 1.64350003512817, -0.360306143503514, 0.801493893596806, 1.61930267687538, 3.06820960503683, 0.69471524580275, 1.28124561222986, 1.6913173367059, 1.04636143814332, 1.11302936162596, 1.99533187428913, 0.318848638678352, -0.277057246687689, -0.468697749831084, 0.686525933464132, -0.703659492663314, -0.350514656137706, -0.102093677209163, -0.0995430145293483, 2.21551377619565, 1.33087648510414, 2.39027511927468, 1.87204698502111, -0.08081702266027, 1.49582159144654, 2.05262755621631, -0.274649950151283, 0.806333271576621, -0.295083642553369, 1.14188028467865, 2.26171505198662, 0.568499671930355, -0.822712589501818, 1.35254395875311, -0.348451441473781, 1.70768831790743, 0.589109063201221, 0.553954820077755, -0.041156301668746, 0.670775283845987, 0.717178375867647, 1.43242912549535, 0.692392904936584, 0.943363692110682, 1.73351542020027, 1.09731161966518, 2.63089173658816, 1.5606106990022, 2.32956476445216, 0.721176504365539, -0.266731544140915, 0.750851605959735, 1.0179884145688, 1.37707272711033, 1.79600855752744, 0.159322582901431, -1.20547175082621, -0.128055991062489, -0.341309958802449, 2.60511404288097, 1.74442372848854, 1.86208220595338, 1.3951558154762, 1.50911869633033, 0.877449874169367, 1.09258464717828, 0.64212008566637, 0.640344775652989, 2.02857072088428, 2.07789259245098, 1.9317812152325, -0.460793866977601, 0.0939244237506571, 0.319652168607585, 2.06316603678904, 0.307586847873846, -0.133628265290896, -0.0946154337972172, -0.0129036188367304, 1.41027732588589, 1.47774044192679, -1.32987954506654, 1.01625546517674, 1.98035352314648, 1.80634826481736, 1.1196008888913, -1.43661560431758, 1.03102247612239, 0.664253302000163, 0.0153403509437263, 1.02263407077062, 1.78533003266096, -0.179189524250798, 2.91079077756379, 0.461998505080422, 1.88427642902339, 1.14730963670884, -0.00842736285689183, 1.83818899220759, -0.168239137404789, 1.45431813292, 1.21257286750447, 0.446913652570444, 1.02343002517967, 1.64817889039139, -0.742794735203855, 1.59516266091186, 0.121470987016807, 1.64443757129211, 0.370901497333396, 0.901799810316161, 1.68421769916776, -0.384686030990408, 2.55494558598051, 0.185658658115434, 0.156368914107435, 2.02492742587361, 1.11570337639616, 1.2414940398728, -0.390816141686847, 2.52606084457092, 1.0465162367214, 2.23998235965392, 1.30857263546279, 1.78562760450207, 2.11747870473614, 0.995017727655611, 0.821581789809814, 1.69622906894708, 1.52179720849355, 0.552173409756539, 1.40540060404469, 0.263035575330592, 1.25574801441047, 0.715066495066433, 0.968878675006656, 0.51414111303988, 0.864911915844152, -0.480718722837506, 2.2563691256856, 1.20904164990957, 1.31315678959013, 2.07514823866383, 0.713374825429577, 0.9680225725685, 0.257266603361191, 3.0852201921514, 1.85489041041, 2.00044599614444, -0.184117910085318, -0.541102555123778, 0.788266999239183, 1.17035256996267, 0.30922262556707, 2.69772073903203, 0.927310037394132, 0.282391143710711, 0.583485561692142, 3.19358676105577, 1.54234782578152, 2.0236676089818, 1.81282610871047, 2.30102707741098, 1.56795641094836, 0.879928557736952, 0.507997293741287, 1.20077197539334, 1.16479929880001, 1.69365769622557, 1.13332425333661, 0.26053684136928, 0.602481184752218, 1.25715863936297, 0.719826080855816, 2.00796759211016, 2.15521962402319, 0.797205050866595, 0.67859045291761, -0.621053917060514, 1.56810525899318, 1.67128024717795, 2.46025952177705, -0.637719374286223, 2.29850108220997, 0.846300171205857, 2.57914884558458, 3.05523518552608, 2.28448665087213, 1.41740331727998), 
           ## "score2" = c(1.58364532511348, 1.80851765624737, 2.0695447814074, 3.15534831801052, 2.59495734695049, 0.580354891643012, 0.39332275464196, 2.89292589956318, 2.14816795518773, 3.22702839010139, 1.23819566082197, 2.41937540588991, 0.96005663536765, 2.71157396599263, 1.36678698503217, 2.56317466445015, 2.6609866858316, 0.341949142674551, 3.02816797701792, 3.12795361401459, 0.719845396577818, 3.12886822740957, 1.53586547283502, 1.68423979046863, 2.92429314683495, 2.07714472398578, 3.03992360511188, 2.74188620673818, 3.25554485828952, 2.95091896645618, 1.51863439272671, 2.20288177796984, 1.96826025616227, 0.804419699665426, 2.62368123684843, 1.08519551633309, 2.2487580077081, 0.937377206819621, 1.63601775280424, 0.793005146621726, 3.42921278138977, 2.63343589098283, 0.00318438234357599, 1.31816782690379, 1.5399445206893, 1.01693080585224, 2.49533171288834, 2.72581750023253, 2.66729873189292, 2.95478643646659, 0.324667820708056, 0.794814607508092, 0.0367475107794697, 3.47075230981397, 2.3724723385506, 3.06587933403768, 2.53064986835732, 2.10198344588413, 3.33778246578648, 2.08723476849113, 1.60889579259955, 1.75013251540444, 3.15510474589615, 1.135272760169, 1.13332165763168, -0.321017030347857, 2.60883016891785, 3.15000604820099, 0.800402328263138, 0.419999245450124, 2.65316619364219, 1.45059151487703, 2.52105452531253, 1.3005969335905, 1.5610906852078, 1.32268070388331, 2.95914119477535, 0.531826670537599, 2.18376389266813, 0.5648528173482, 0.86260010187653, 1.585354673122, 2.14393428815136, 3.06202433069828, 1.4292060972646, 3.27718137641215, 2.22828932054008, 1.69118693549726, 2.95982913059558, 2.54882237481208, -1.01216378355869, -0.00852305776173123, 1.95362859055501, 1.64046293549959, 1.80497833825235, 0.485529864539125, 1.10796695287938, 1.13729350858593, 2.55195414795462, 1.81176608668258, 1.67485325637045, 1.4630615508604, 1.62852258725065, 2.72280702365904, 3.20569188339316, 3.18415312566266, 2.67119043540744, 3.17550207341849, 2.18852647272121, 2.49906359684503, 0.052381688588012, 2.42073724617646, 3.17347624977911, 0.553768443004754, 1.63324879405169, 1.39220376512214, 2.31987137738078, 3.09984767220601, 1.59396337240913, 4.41074642682032, 3.15889988480835, 2.33838959155623, 2.4561773439209, 1.68595533358442, 3.40434402019996, 1.58973005091513, 1.91189748384991, 2.32487559471631, 3.18509980019251, 1.74449142655912, 2.88444792089563, 1.51143893037353, 1.27262382682244, 0.811744727083304, 1.46205758408742, 2.11935121731696, 3.31817809545599, 3.44308055765009, 2.24902621164524, 2.8157023268506, 1.26539219362214, 2.25815327802218, 1.14713923117729, 2.21564875855347, 1.2907897879976, 2.71086552315894, 1.55262814123793, 1.6617016958065, 2.5172334221407, 2.09870359432402, 2.74368561583684, 1.72144985851539, 2.53907168061795, 1.91166053032995, 1.25424249184674, 0.439921548898607, 3.08295652542379, -0.341056002563677, 2.20630526603203, 2.76474257118102, -0.125068581043938, 2.52117866630317, 1.95357710004389, 0.850528279029067, 2.6293383077002, 1.27352852400835, 1.61358267769029, 1.32828561011569, 2.90038619036856, 2.88684169061633, 2.39027811189946, 1.07248850977773, 2.7458392287806, 2.49482415664264, 1.97806853827693, 2.58802232626581, 2.75649107400237, 1.5059737273813, 1.26668437138653, 1.99897960601221, 2.80582569677651, 3.10930938187503, 1.69032051784047, 1.09142175187253, 2.26302612768668, 1.97908219242358, 1.78765749235222, 0.968896080225028, 2.13951073969625, 2.16621798461647), 
           ## "score3" = c(3.01874617094183, 2.81574745793094, 1.62866945007749, 2.40083228421628, 3.29454512656751, 3.38979430070017, 1.79192382457051, 2.63632398252914, 1.37332731829691, 2.74352160587601, 4.10177950308713, 3.75578150802734, 2.76176644398128, 3.98744470341339, 3.74139012838382, 3.08934726649582, 2.04505614384762, 2.80484961533276, 3.92552126209408, 3.48297852483661, 2.40368936327979, 0.81471316183047, 2.32513406212488, 0.880938808089826, 1.7348019784691, 2.6263384448453, 2.31244456961208, 2.12784117328231, 2.89823899377518, 2.74621946989754, 1.14625954552086, 2.92205393392463, 3.96856634052454, 3.18492595999031, 1.62005642166242, 1.56448563763963, 3.36208722860661, 1.24091324624029, 2.67545599042767, 2.34843701145534, 4.08655139944051, 2.23745511996871, 2.17133746499891, 3.83447390308845, 2.03234801324009, 2.97118466452414, 3.23252515257539, 2.69879131849582, 2.32238541685067, 3.65522763623522, 2.59936245296826, 2.66544343492665, 4.36795395319196, 5.13776710365012, 3.50581926452903, 3.78634238423916, 2.09778805582136, 3.53289699232833, 2.35410574645079, 3.29098748842977, 1.76240553112278, 2.54382372488219, 2.16967734527527, 3.34011564367426, 4.06637639568217, 4.2161258380798, 3.73569065763305, 2.51879138268442, 3.56274476285812, 1.7536802881108, 3.38092221262568, 1.56957274720331, 1.9515544951214, 2.78149644946541, 1.51006376326446, 4.17270628121431, 1.52017297842834, 2.56961218392278, 1.94836135795655, 4.5225863440541, 3.59282805458608, 2.77733849098073, 3.71289427624846, 3.71660083374105, 3.44024186438414, 3.1588306213181, 3.65976413833195, 5.22051966293556, 1.8160549259346, 2.92604416550251, 1.93791604956191, 3.7335810357291, 3.32269219847885, 2.65102022865129, 4.28352566424672, 1.98551195111823, 2.48993572589294, 2.83283025384466, 2.69733221439384, 5.0264704724602, 3.90090563841005, 3.13542904045584, 2.79871104580062, 2.19316325900686, 3.64412412375921, 2.66334087934639, 1.26829648875503, 3.26192066260897, 2.08330240189068, 2.43143552485088, 2.13417955824643, 3.82549391179805, 2.19986771579267, 3.97583008678438, 5.70007553074188, 2.8646104031143, 2.89396883604053, 1.65593619485464, 3.4431218286128, 3.9611177416634, 2.75856418334431, 3.08295489110829, 2.63827524223176, 3.33386019980123, 3.26560942097052, 6.01290574660275, 2.65526986231257, 4.06255745328506, 2.2703149259595, 3.05654772097641, 3.46782971192005, 2.62735474944868, 3.21016168769331, 4.28960830567623, 1.37316045013292, 2.21646349031662, 3.51091310345695, 4.21762605593289, 3.30510924768834, 3.21029363332494, 3.46886596550588, 1.09565742773757, 4.23840228464858, 3.39099889145765, 2.96880108325314, 1.38119947823422, 3.45126627813282, 2.30915663637694, 4.40544562193991, 1.29865731217496, 3.19224559727714, 2.29704323850277, 2.1914441366512, 2.36180125847461, 4.73734542796118, 0.739521736857817, 1.38752790611354, 3.65374019880081, 3.90288072859301, 3.75460848783451, 2.77318923122993, 2.30403137240837, 3.5066473573338, 3.61623429360761, 1.33312072548464, 2.66374577425735, 3.50717985674657, 1.30260929849155, 2.79307277609727, 2.60140297182384, 1.81138017251911, 3.45256540413909, 3.20758970392942, 1.78987762388159, 3.76741505428064, 2.40097230874304, 1.43902722719435, 2.00433595707106, 4.09325100838442, 3.91714288600737, 2.22695064486765, 2.5241641823542, 1.86929681598015, 2.57116456833321, 2.16041635013634, 2.39901332709606, 2.22610922180923, 2.10750764882604, 2.96426815294228, 2.69582189760649), 
           ## "eventtime1" = c(0.147154531017788, 0.988746345467002, 0.266304131111328, 0.00338837308601289, 1.75242534349986, 1.0140856331589, 0.122732792314314, 0.2701839140227, 1.32337517313424, 0.873947415014138, 0.804865133971663, 0.10634919347321, 0.226637022123138, 0.128468800826553, 1.13043993981617, 0.23567445845044, 0.0157005154510231, 3.16077173131669, 0.0151432932057198, 0.81635259703984, 0.697665345436564, 0.378750341794865, 0.422273156184825, 0.586279788815492, 1.02829630356905, 0.908532837416961, 0.436961370436866, 0.752551644614578, 0.516417019310471, 0.579420369986465, 0.0133051047114376, 0.0245506950204939, 0.115160781574875, 0.751877267578412, 1.25019057174279, 0.292767941734102, 0.256114447215143, 0.710851900452458, 0.315058508232206, 0.437912827175906, 0.892653255090483, 0.691379976548468, 1.01337237755889, 0.359780136973134, 0.115903892163612, 0.158101027546465, 0.0666124551862339, 0.0318933613193749, 0.0935388987671774, 1.03084907678867, 0.79677638643422, 1.8691806213408, 0.192586594635178, 0.273524937703571, 0.67771169027812, 0.0738505790182695, 0.0297654911762159, 0.0760831868512291, 0.816007986857723, 3.12980392170762, 0.741572934855366, 0.328972948435232, 0.170636601904655, 0.443016001468461, 0.455513158646634, 0.0674624795680817, 1.84743844735416, 0.552760677865754, 0.641809653821997, 0.330240561185664, 0.0628994395435676, 0.354162880997499, 0.196633467539047, 0.0586607842718881, 0.0165175760750264, 0.583871062122504, 0.497514166537786, 1.66804432894791, 0.112796593513172, 0.196786862542436, 0.758572375511261, 0.674560948567573, 0.126302889786385, 1.15782390071277, 0.0145072608882747, 0.409508853357864, 0.419017069959433, 0.363239826710306, 1.46903210918867, 0.281803583167114, 0.0410804350417943, 0.276000695105524, 0.297517864408955, 0.294237617707058, 0.0174338388962735, 0.925854284560872, 0.396093462640563, 0.289913318439082, 2.95574291205351, 0.182878425624953, 0.756696567187896, 1.29234947711194, 0.748963142021847, 2.36933048802155, 0.0697659837126843, 0.318747908783696, 0.420377490121858, 1.00891638108322, 0.264304555089164, 1.0629138346662, 0.0652835531777393, 0.816872512059484, 0.259948052956663, 0.218013321436759, 0.584819784772081, 2.02102005892197, 0.489006244150553, 0.0397450780787017, 0.14829323642126, 0.127176168359671, 0.7575342766353, 0.450752832493371, 1.316559071055, 1.68789974173792, 0.303139102280336, 1.02001220748442, 0.231979940784388, 0.0976870425948621, 0.986647852055228, 0.583741138630392, 0.12850424094713, 0.0597219405089971, 0.686929139440549, 0.0163683634053247, 0.48570911606631, 0.367411372063561, 1.44564236927734, 0.242930892499069, 0.098241936545067, 0.727013592318114, 0.610878960790024, 1.06533455613599, 0.0427344240432022, 0.852939712059502, 0.262462770697741, 0.0354783929547184, 0.0063058552155784, 0.019985159318276, 0.362471949820652, 0.095951027070843, 1.15540688581979, 0.244586025611237, 0.022496240042542, 0.225785392045219, 0.452728042879193, 0.469820264172848, 0.222848264610967, 0.183230439577219, 0.719459594292462, 0.820692535076216, 0.882143970814932, 1.39245340107264, 0.0649842083744379, 0.0657658347503663, 0.521593592502683, 0.423991325249481, 0.128025557668941, 2.04248561401372, 1.16615838213277, 0.0462382916606336, 0.943222402257644, 0.0311273118276984, 0.16727983902946, 1.07020410340138, 0.0291880991127751, 1.11584557187517, 0.0662743088221081, 0.786455652771557, 0.496171143684, 0.0985658627106901, 0.0918418692401118, 0.834740618177621, 1.56005891131313, 0.0192490284322769, 0.139316769986157, 1.13358527848279, 0.261395317702592, 0.445400531573553, 0.00388676344762903, 0.154749061980161), 
           ## "status1" = c(1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0), 
           ## "eventtime2" = c(0.260715358726227, 1.10771127658832, 0.150702335009323, 0.195495532097253, 0.90646923012503, 0.0506314773663807, 1.70618438023517, 0.798106066514742, 1.64706089860666, 0.0288871071587158, 0.21355674558509, 0.342237934394484, 1.39332222606092, 0.490799591661917, 0.56429918685456, 0.568275887025847, 0.415398365961037, 1.61095369173802, 0.240472142544179, 0.242425408138084, 0.046147979637316, 0.478691376786461, 0.0814539506192382, 1.45878564265112, 0.669934943798178, 0.634673989193024, 0.0499658153434468, 0.267705147601441, 0.13809102142513, 0.0626255922279662, 2.52078680293203, 0.263484384702317, 0.00693268625804985, 1.8223962321102, 0.214223081366421, 0.082145315462958, 0.309554085303775, 0.10898031470078, 0.186360281641481, 0.0185626899949151, 0.138363317258372, 1.49837112956646, 0.426028489055661, 0.414432589096446, 0.341025611072548, 1.77683520318534, 0.914742195228757, 0.160832501762517, 0.36686576620718, 0.502721008661938, 0.223932636272035, 0.193158033774083, 0.792050384897658, 0.0255540876856203, 0.399075299561664, 0.730889702794916, 0.286327928721284, 0.0456415065456314, 0.207596710228561, 0.611167636480941, 0.307922110206337, 0.936012985071278, 0.0477537960733674, 0.231350344819024, 0.193524448233391, 2.22703167846935, 0.448342182942628, 0.0200795365830742, 0.121806382369748, 0.730149447621282, 0.102985426996135, 0.374272581569644, 0.741834694618047, 0.0188247298134229, 1.39977567829357, 0.015796653034331, 2.61659860202646, 1.09901887949598, 0.102931084382066, 0.95781588421076, 0.127564829612624, 2.56622685705737, 0.215400564266406, 0.230514394226964, 0.208514173729103, 0.736068004688609, 1.29699293907984, 1.15352058632124, 2.4902134260112, 1.07340379090702, 2.58530318559949, 0.402283196895746, 0.260675476493751, 0.229341384201603, 1.02927581707082, 0.422185776745904, 0.191294849167874, 2.91478619368682, 0.927243262482265, 0.227741012310683, 0.180960008906741, 0.11447745130462, 0.696249768661502, 0.157477314883201, 0.403047259382678, 0.387039425717549, 0.981610090290453, 0.27851624548116, 0.908984843820639, 0.19783668982068, 0.786211823279842, 1.51861540740554, 0.358428008112341, 0.689779038324286, 0.920962448305589, 1.50977696727228, 0.751517033602002, 0.544890088141167, 0.133739013428693, 0.185449786095539, 1.61947504339791, 0.873466139630313, 0.434723817523281, 1.05112639306822, 0.281314777078326, 0.459562561516924, 0.369954900558988, 0.0859569086177876, 0.733340572347494, 1.60390084295858, 0.0698855882759811, 0.233649862108796, 4.9373904785444, 1.83883155148774, 0.645626899878736, 0.289428530917379, 0.464499813057233, 0.709862994695663, 0.5673945019793, 0.203714797300519, 1.17235498474168, 0.13449888571972, 0.40467641517944, 2.26188165392426, 0.0821651258153384, 0.195782497317003, 0.842023738988, 0.0688806089144742, 0.281414788527317, 0.65877515467977, 0.296819255382972, 0.0339161898775004, 0.547321979296716, 0.739589884508609, 0.0842714723012896, 1.60524752544741, 0.0306189041665206, 0.934024955189682, 0.0517380635885417, 0.11982097348084, 0.137115868030633, 0.236818547868596, 1.67529428199042, 0.08439855038231, 0.203092930083532, 0.902977208663775, 0.0169883535249551, 0.609659234737125, 0.138044979714104, 0.605481263332028, 1.55412861453824, 0.210374112392006, 2.000335691492, 0.843146962569521, 0.330845100935063, 1.46693676761602, 0.54268875081152, 0.231934603232632, 0.0618084058073134, 0.107353738232707, 0.0908231725834454, 0.123045126873004, 1.5432074013948, 0.57229719531974, 1.74786427905333, 1.25298440098201, 0.107967152003016, 0.0499273662825838, 0.090234342659507, 0.0195357778074645), 
           ## "status2" = c(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0), 
           ## "eventtime3" = c(0.293733014310895, 2.99448384259032, 1.33980963104124, 0.496300941943964, 1.22099704012309, 0.0373721538212026, 0.187137345501571, 0.323353691247819, 0.780978115280896, 0.310442431933021, 1.03796020197828, 1.24147211309831, 0.723207099456172, 1.34698546721254, 0.496082238658226, 1.44827529079895, 0.521865161625976, 0.68353467186253, 0.0198144012665529, 0.18416592198316, 2.31754726208254, 1.77382739085223, 0.333985198539388, 0.201898095701069, 0.037804703116014, 0.451823603145119, 0.537318116873933, 0.0232303865342007, 0.208453658687415, 0.529862782119121, 1.69534262583851, 0.739995644446326, 0.584670890400981, 0.660194671591075, 2.43692159047791, 0.321378717095711, 0.470858907291999, 0.300885586737895, 0.0849040174277981, 0.346258729789037, 2.18121012735058, 1.46578570695944, 0.619693384243129, 4.42551925063202, 0.000597661984300133, 1.00932679616087, 0.359839679192164, 0.240645438675249, 1.08569678415356, 1.45416021630186, 1.6789996741874, 1.69425750511157, 0.00653236821680537, 0.51073806177961, 0.369948552020504, 1.59945127194625, 1.3236125713606, 1.48425067326426, 0.836247284887988, 0.893571488741335, 0.578189318532236, 0.0358568453949352, 0.210830021086216, 0.0155471175212725, 0.394160619241234, 0.0326274558475622, 0.266731382084703, 0.669753493153975, 0.717969431771765, 0.88286046637068, 0.791108651161664, 0.898976499057733, 0.524081920308154, 2.70977349940292, 1.3893057822478, 3.03969626306362, 0.73321636007742, 1.92017961391452, 0.124273130677993, 0.945653065011673, 0.00825042251846677, 0.658779176139988, 0.767451781761614, 1.90638352080968, 1.58163544871625, 0.10784913954513, 0.949147655286187, 0.168078340234353, 0.593803958726638, 1.54462579103663, 0.186956513160319, 0.629283258841148, 0.0873049052077904, 0.733068239947979, 1.40420931094632, 0.192337129955149, 0.333401945283805, 0.0344329731559355, 0.274189826651433, 0.910836697306516, 0.303391134016558, 0.0357706691919942, 3.29871717520528, 0.0630263274790764, 0.870804234130271, 0.697519244529544, 0.575385421918495, 0.534992787498408, 0.246228993287661, 0.856935582483809, 0.397308648829461, 0.652084221032082, 0.748507989143236, 1.01316574482707, 0.436163629031014, 0.838827345700121, 0.355026910826948, 0.0226469858363734, 0.207005798093843, 0.143966032607798, 0.103899316845053, 0.460289468073832, 0.636746770010642, 0.00925149206114618, 0.697405223382561, 0.153286469753514, 0.231242138311338, 0.773299188841039, 0.186848489963772, 0.110831690172533, 2.62681005866194, 0.200019215644149, 0.210402688604894, 1.19494880583752, 1.06805406720807, 1.907865681834, 1.11206305537185, 0.618034748898127, 0.314894371331222, 0.216433776042293, 0.138175934415695, 0.0223831497736912, 1.0080281416691, 0.000886687715363389, 0.149976647673442, 0.587403117291067, 0.763739129916681, 1.13659499025919, 0.337817817638958, 2.5394672812709, 0.438141548521403, 0.545826010773546, 0.123791923007256, 0.221596126459003, 0.262950329269119, 0.0594304439601256, 1.85251812173937, 1.14050193820485, 0.207557858461683, 0.139412620676529, 0.412037497960816, 0.572701674131632, 0.482605565484431, 0.931729755352493, 0.578474308680047, 0.217751594386994, 0.400383897661771, 0.995068312969113, 0.0731883850535335, 0.707260090899151, 0.630421212270399, 0.219220847146326, 0.769801122154004, 1.28525629916782, 0.114169640433724, 0.442909041647634, 0.411128758763132, 0.611387496129468, 0.569868990840883, 1.12728015256685, 1.08061234409855, 0.389625906632013, 0.542099314514301, 0.798104775082986, 0.394623881474312, 0.675502904922754, 0.0858133655206339, 0.129660053960637, 0.268116405477624, 0.694271357435761), 
           ## "status3" = c(0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0))


