% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Identify_CellType.R
\name{Identify_CellType}
\alias{Identify_CellType}
\title{Identify cell type of each cluster}
\usage{
Identify_CellType(seurat_object, Marker_gene_table)
}
\arguments{
\item{seurat_object}{seurat object}

\item{Marker_gene_table}{data.frame, indicating marker gene and its
corresponding cell type. Marker_gene_table should contain two columns: 'CellType'
represent correseponding cell types of each marker and 'Marker' represent Markers}
}
\value{
Cell type with the highest power in each cluster
}
\description{
This function has three steps to identify cell type of each cluster.
(1) Calculate the power of each known marker based on AUC
(area under the receiver operating characteristic curve of gene expression)
which indicates the capability of marker i from cell type m to distinguish
cluster j and the other clusters. (2) Calculate the united power (UP)
for cell type m across each cluster j. (3) For each cluster j we determine
the cell type according to UP. Generally, the cluster beongs to the cell
type which have the highest united power or higher than the threshold of
the united power (for example > 0.9 power).
}
\examples{
KnownMarker=data.frame(c('AIF1','BID','CCL5','CD79A','CD79B','MS4A6A'),c('a','a','a','b','b','b'))
data("pbmc_small")
colnames(KnownMarker)=c('Marker','CellType')
CT <- Identify_CellType(pbmc_small,KnownMarker)
}
