/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRDataFileOpenDialog;

public class DataMergeDialog
extends JDialog {
    private JButton browse1Button;
    private JButton browse2Button;
    private JPanel buttonPane;
    private JLabel by11Label;
    private JComboBox by11List;
    private JLabel by12Label;
    private JComboBox by12List;
    private JLabel by13Label;
    private JComboBox by13List;
    private JLabel by21Label;
    private JComboBox by21List;
    private JLabel by22Label;
    private JComboBox by22List;
    private JLabel by23Label;
    private JComboBox by23List;
    private JCheckBox byall1Check;
    private JCheckBox byall2Check;
    private JButton cancelButton;
    private JLabel dataset1Label;
    private JComboBox dataset1List;
    private JPanel dataset1Pane;
    private JLabel dataset2Label;
    private JComboBox dataset2List;
    private JPanel dataset2Pane;
    private JPanel datasetPane;
    private JButton helpButton;
    private JTextField nameText;
    private JButton outputBrowse;
    private JTextField rNameText;
    private JLabel rSaveLabel;
    private JCheckBox saveCheck;
    private JLabel saveLabel;
    private JPanel savePane;
    private JCheckBox sortCheck;
    private JButton submitButton;
    private JLabel suffix1Label;
    private JTextField suffix1Text;
    private JLabel suffix2Label;
    private JTextField suffix2Text;

    public DataMergeDialog() {
        this.initComponents();
        this.getRootPane().setDefaultButton(this.submitButton);
        this.initLists();
        this.refreshDatasetLists(0, "", "");
        if (this.isDatasetListValid(1)) {
            this.refreshBy1List();
            this.refreshBy2List();
        }
        this.updateValidity();
        this.pack();
    }

    private void initLists() {
        this.getDataset1List().setModel(new DefaultComboBoxModel());
        this.getDataset2List().setModel(new DefaultComboBoxModel());
        this.getBy11List().setModel(new DefaultComboBoxModel());
        this.getBy11List().insertItemAt("", 0);
        this.getBy11List().setSelectedIndex(0);
        this.getBy12List().setModel(new DefaultComboBoxModel());
        this.getBy12List().insertItemAt("", 0);
        this.getBy12List().setSelectedIndex(0);
        this.getBy13List().setModel(new DefaultComboBoxModel());
        this.getBy13List().insertItemAt("", 0);
        this.getBy13List().setSelectedIndex(0);
        this.getBy21List().setModel(new DefaultComboBoxModel());
        this.getBy21List().insertItemAt("", 0);
        this.getBy21List().setSelectedIndex(0);
        this.getBy22List().setModel(new DefaultComboBoxModel());
        this.getBy22List().insertItemAt("", 0);
        this.getBy22List().setSelectedIndex(0);
        this.getBy23List().setModel(new DefaultComboBoxModel());
        this.getBy23List().insertItemAt("", 0);
        this.getBy23List().setSelectedIndex(0);
    }

    private void updateValidity() {
        boolean isValid;
        this.dataset1List.setEnabled(this.isDatasetListValid(1));
        this.dataset2List.setEnabled(this.isDatasetListValid(2));
        boolean bl = isValid = this.getDataset1() != null || this.getDataset2() != null;
        if (isValid) {
            if (this.getSelectBy11List().equals("") ^ this.getSelectBy21List().equals("")) {
                isValid = false;
            }
            if (this.getSelectBy12List().equals("") ^ this.getSelectBy22List().equals("")) {
                isValid = false;
            }
            if (this.getSelectBy13List().equals("") ^ this.getSelectBy23List().equals("")) {
                isValid = false;
            }
        }
        this.submitButton.setEnabled(isValid);
    }

    public boolean isDatasetListValid(int i) {
        switch (i) {
            case 1: {
                return this.dataset1List.getItemCount() > 1;
            }
            case 2: {
                return this.dataset2List.getItemCount() > 1;
            }
        }
        return true;
    }

    private void refreshDatasetLists(int i, String keep1, String keep2) {
        Object[] datasets = RUtils.getDatasetList();
        ArrayList<Object> extdata = new ArrayList<Object>();
        extdata.add("");
        for (int k = 0; k < datasets.length; ++k) {
            extdata.add(datasets[k]);
        }
        Object[] dataModel = extdata.toArray();
        this.getDataset1List().removeAllItems();
        this.getDataset1List().setModel(new DefaultComboBoxModel<Object>(dataModel));
        this.getDataset2List().removeAllItems();
        this.getDataset2List().setModel(new DefaultComboBoxModel<Object>(dataModel));
        int n = dataModel.length;
        for (int j = 0; j < n; ++j) {
            String dataset = dataModel[j].toString();
            if (j == 0) {
                this.getDataset1List().setSelectedIndex(0);
                this.getDataset2List().setSelectedIndex(0);
                continue;
            }
            if (dataset.equals(keep1)) {
                this.getDataset1List().setSelectedIndex(j);
            }
            if (!dataset.equals(keep2)) continue;
            this.getDataset2List().setSelectedIndex(j);
        }
        switch (i) {
            case 1: {
                this.refreshBy1List();
                break;
            }
            case 2: {
                this.refreshBy2List();
            }
        }
        this.updateValidity();
    }

    private void refreshBy1List() {
        JComboBox[] byLists = new JComboBox[]{this.getBy11List(), this.getBy12List(), this.getBy13List()};
        if (this.isDatasetListValid(1) && !this.getDataset1().equals("")) {
            String dataset = this.getDataset1();
            String[] colnames = RUtils.colnames(dataset);
            int colLength = colnames.length;
            for (JComboBox list : byLists) {
                int k;
                int m = list.getItemCount();
                for (k = 1; k < m; ++k) {
                    list.removeItemAt(1);
                }
                for (k = 0; k < colLength; ++k) {
                    list.insertItemAt(colnames[k], k + 1);
                }
                list.setSelectedIndex(0);
            }
        }
        this.updateValidity();
    }

    private void refreshBy2List() {
        JComboBox[] byLists = new JComboBox[]{this.getBy21List(), this.getBy22List(), this.getBy23List()};
        if (this.isDatasetListValid(2) && !this.getDataset2().equals("")) {
            String dataset = this.getDataset2();
            String[] colnames = RUtils.colnames(dataset);
            int colLength = colnames.length;
            for (JComboBox list : byLists) {
                int k;
                int m = list.getItemCount();
                for (k = 1; k < m; ++k) {
                    list.removeItemAt(1);
                }
                for (k = 0; k < colLength; ++k) {
                    list.insertItemAt(colnames[k], k + 1);
                }
                list.setSelectedIndex(0);
            }
        }
        this.updateValidity();
    }

    public static String getSelectedItem(JComboBox cBox) {
        if (cBox != null && cBox.getItemCount() > 0) {
            return (String)cBox.getSelectedItem();
        }
        return null;
    }

    public static Object[] getSelectedItems(JList list) {
        if (list != null) {
            return list.getSelectedValues();
        }
        return null;
    }

    public JPanel getDataset1Pane() {
        return this.dataset1Pane;
    }

    public void setDataset1Pane(JPanel dataset1Pane) {
        this.dataset1Pane = dataset1Pane;
    }

    public JPanel getDataset2Pane() {
        return this.dataset1Pane;
    }

    public void setDataset2Pane(JPanel dataset2Pane) {
        this.dataset2Pane = dataset2Pane;
    }

    public JPanel getSavePane() {
        return this.savePane;
    }

    public void setSavePane(JPanel savePane) {
        this.savePane = savePane;
    }

    public JComboBox getDataset1List() {
        return this.dataset1List;
    }

    public String getDataset1() {
        return DataMergeDialog.getSelectedItem(this.dataset1List);
    }

    public JComboBox getDataset2List() {
        return this.dataset2List;
    }

    public String getDataset2() {
        return DataMergeDialog.getSelectedItem(this.dataset2List);
    }

    public JComboBox getBy11List() {
        return this.by11List;
    }

    public String getSelectBy11List() {
        return DataMergeDialog.getSelectedItem(this.by11List);
    }

    public JComboBox getBy12List() {
        return this.by12List;
    }

    public String getSelectBy12List() {
        return DataMergeDialog.getSelectedItem(this.by12List);
    }

    public JComboBox getBy13List() {
        return this.by13List;
    }

    public String getSelectBy13List() {
        return DataMergeDialog.getSelectedItem(this.by13List);
    }

    public JComboBox getBy21List() {
        return this.by21List;
    }

    public String getSelectBy21List() {
        return DataMergeDialog.getSelectedItem(this.by21List);
    }

    public JComboBox getBy22List() {
        return this.by22List;
    }

    public String getSelectBy22List() {
        return DataMergeDialog.getSelectedItem(this.by22List);
    }

    public JComboBox getBy23List() {
        return this.by23List;
    }

    public String getSelectBy23List() {
        return DataMergeDialog.getSelectedItem(this.by23List);
    }

    private int setTextUsingFileChooser(JTextField textField, int mode) {
        String workingDir = RUtils.evalAsString("getwd()");
        JFileChooser fc = new JFileChooser(workingDir);
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(mode);
        int fcReturnState = fc.showOpenDialog(this);
        if (fcReturnState == 0) {
            textField.setText(fc.getSelectedFile().toString().replace('\\', '/'));
        }
        return fcReturnState;
    }

    private void initComponents() {
        this.datasetPane = new JPanel();
        this.dataset1Pane = new JPanel();
        this.dataset1Label = new JLabel();
        this.dataset1List = new JComboBox();
        this.browse1Button = new JButton();
        this.by11Label = new JLabel();
        this.by11List = new JComboBox();
        this.by12Label = new JLabel();
        this.by12List = new JComboBox();
        this.by13Label = new JLabel();
        this.by13List = new JComboBox();
        this.byall1Check = new JCheckBox();
        this.suffix1Label = new JLabel();
        this.suffix1Text = new JTextField();
        this.dataset2Pane = new JPanel();
        this.dataset2Label = new JLabel();
        this.dataset2List = new JComboBox();
        this.browse2Button = new JButton();
        this.by21Label = new JLabel();
        this.by21List = new JComboBox();
        this.by22Label = new JLabel();
        this.by22List = new JComboBox();
        this.by23Label = new JLabel();
        this.by23List = new JComboBox();
        this.byall2Check = new JCheckBox();
        this.suffix2Label = new JLabel();
        this.suffix2Text = new JTextField();
        this.savePane = new JPanel();
        this.sortCheck = new JCheckBox();
        this.rSaveLabel = new JLabel();
        this.rNameText = new JTextField();
        this.saveCheck = new JCheckBox();
        this.saveLabel = new JLabel();
        this.nameText = new JTextField();
        this.outputBrowse = new JButton();
        this.buttonPane = new JPanel();
        this.cancelButton = new JButton();
        this.submitButton = new JButton();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Merge");
        this.setMinimumSize(new Dimension(30, 30));
        this.dataset1Pane.setBorder(BorderFactory.createTitledBorder("Dataset 1"));
        this.dataset1Pane.setMinimumSize(new Dimension(30, 30));
        this.dataset1Label.setLabelFor(this.dataset1List);
        this.dataset1Label.setText("Dataset 1:");
        this.dataset1List.setMinimumSize(new Dimension(120, 24));
        this.dataset1List.setPreferredSize(new Dimension(120, 24));
        this.dataset1List.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.dataset1ListActionPerformed(evt);
            }
        });
        this.browse1Button.setText("Browse...");
        this.browse1Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.browse1ButtonActionPerformed(evt);
            }
        });
        this.by11Label.setLabelFor(this.by11List);
        this.by11Label.setText("Variable 1:");
        this.by11Label.setToolTipText("Pick variable from Dataset 1 that corresponds to Variable 1 in Dataset 2.  Necessary if column names do not match.");
        this.by11List.setPreferredSize(new Dimension(120, 24));
        this.by11List.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by11ListActionPerformed(evt);
            }
        });
        this.by12Label.setLabelFor(this.by12List);
        this.by12Label.setText("Variable 2:");
        this.by12Label.setToolTipText("Pick variable from Dataset 1 that corresponds to Variable 2 in Dataset 2.  Necessary if column names do not match.");
        this.by12List.setPreferredSize(new Dimension(120, 24));
        this.by12List.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by12ListActionPerformed(evt);
            }
        });
        this.by13Label.setLabelFor(this.by13List);
        this.by13Label.setText("Variable 3:");
        this.by13Label.setToolTipText("Pick variable from Dataset 1 that corresponds to Variable 3 in Dataset 2.  Necessary if column names do not match.");
        this.by13List.setPreferredSize(new Dimension(120, 24));
        this.by13List.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by13ListActionPerformed(evt);
            }
        });
        this.byall1Check.setSelected(true);
        this.byall1Check.setText("By All");
        this.byall1Check.setToolTipText("If selected, then all rows in Dataset 1 will be included, even if there is no corresponding row in Dataset 2.");
        this.byall1Check.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.byall1Check.setMargin(new Insets(0, 0, 0, 0));
        this.suffix1Label.setText("Suffix: ");
        this.suffix1Label.setToolTipText("If column names match in Dataset 1 and 2, then this suffix will be added to the column name for Dataset 1.");
        this.suffix1Text.setText(".1");
        GroupLayout dataset1PaneLayout = new GroupLayout((Container)this.dataset1Pane);
        this.dataset1Pane.setLayout((LayoutManager)dataset1PaneLayout);
        dataset1PaneLayout.setHorizontalGroup((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(1).add((GroupLayout.Group)dataset1PaneLayout.createSequentialGroup().addContainerGap().add((Component)this.dataset1Label).addPreferredGap(0).add((Component)this.dataset1List, -2, -1, -2).addPreferredGap(0).add((Component)this.browse1Button).addContainerGap()).add((GroupLayout.Group)dataset1PaneLayout.createSequentialGroup().add((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(2).add((GroupLayout.Group)dataset1PaneLayout.createSequentialGroup().add(47, 47, 47).add((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(1).add((Component)this.by11Label).add((Component)this.by12Label, -1, -1, Short.MAX_VALUE).add((Component)this.by13Label, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)dataset1PaneLayout.createSequentialGroup().addContainerGap().add((Component)this.suffix1Label))).addPreferredGap(0).add((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(1).add((GroupLayout.Group)dataset1PaneLayout.createSequentialGroup().add((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(1).add((Component)this.by13List, 0, -1, Short.MAX_VALUE).add((Component)this.by12List, 0, -1, Short.MAX_VALUE).add((Component)this.by11List, -2, -1, -2).add((GroupLayout.Group)dataset1PaneLayout.createSequentialGroup().add((Component)this.byall1Check).addPreferredGap(0, 67, -2))).add(70, 70, 70)).add((GroupLayout.Group)dataset1PaneLayout.createSequentialGroup().add((Component)this.suffix1Text, 0, 0, Short.MAX_VALUE).addContainerGap()))));
        dataset1PaneLayout.linkSize(new Component[]{this.by11Label, this.by12Label, this.by13Label}, 1);
        dataset1PaneLayout.linkSize(new Component[]{this.by11List, this.by12List, this.by13List}, 1);
        dataset1PaneLayout.linkSize(new Component[]{this.byall1Check, this.suffix1Text}, 1);
        dataset1PaneLayout.setVerticalGroup((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(1).add((GroupLayout.Group)dataset1PaneLayout.createSequentialGroup().add((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(3).add((Component)this.dataset1Label).add((Component)this.dataset1List, -2, -1, -2).add((Component)this.browse1Button)).addPreferredGap(1).add((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(3).add((Component)this.by11Label).add((Component)this.by11List, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(3).add((Component)this.by12Label).add((Component)this.by12List, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(3).add((Component)this.by13List, -2, -1, -2).add((Component)this.by13Label)).addPreferredGap(0).add((Component)this.byall1Check).addPreferredGap(0).add((GroupLayout.Group)dataset1PaneLayout.createParallelGroup(3).add((Component)this.suffix1Text, -2, 19, -2).add((Component)this.suffix1Label)).addContainerGap(25, Short.MAX_VALUE)));
        this.dataset2Pane.setBorder(BorderFactory.createTitledBorder("Dataset 2"));
        this.dataset2Pane.setMinimumSize(new Dimension(30, 30));
        this.dataset2Label.setText("Dataset 2:");
        this.dataset2List.setPreferredSize(new Dimension(120, 24));
        this.dataset2List.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.dataset2ListActionPerformed(evt);
            }
        });
        this.browse2Button.setText("Browse...");
        this.browse2Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.browse2ButtonActionPerformed(evt);
            }
        });
        this.by21Label.setLabelFor(this.by21List);
        this.by21Label.setText("Variable 1:");
        this.by21Label.setToolTipText("Pick variable from Dataset 2 that corresponds to Variable 1 in Dataset 1.  Necessary if column names do not match.");
        this.by21List.setPreferredSize(new Dimension(120, 24));
        this.by21List.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by21ListActionPerformed(evt);
            }
        });
        this.by22Label.setLabelFor(this.by22List);
        this.by22Label.setText("Variable 2:");
        this.by22Label.setToolTipText("Pick Variable from Dataset 2 that corresponds to Variable2 from Dataset 1.  Necessary if column names do not match.");
        this.by22List.setPreferredSize(new Dimension(120, 24));
        this.by22List.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by22ListActionPerformed(evt);
            }
        });
        this.by23Label.setLabelFor(this.by23List);
        this.by23Label.setText("Variable 3:");
        this.by23Label.setToolTipText("Pick variable from Dataset 2 that corresponds to Variable 3 in Dataset 1.  Necessary if column names do not match.");
        this.by23List.setPreferredSize(new Dimension(120, 24));
        this.by23List.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.by23ListActionPerformed(evt);
            }
        });
        this.byall2Check.setSelected(true);
        this.byall2Check.setText("By All");
        this.byall2Check.setToolTipText("If selected, then all rows in Dataset 2 will be included, even if there is no corresponding row in Dataset 1.");
        this.byall2Check.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.byall2Check.setMargin(new Insets(0, 0, 0, 0));
        this.suffix2Label.setText("Suffix:");
        this.suffix2Label.setToolTipText("If column names match in Dataset 1 and 2, then this suffix will be added to the column name for Dataset 2.");
        this.suffix2Text.setText(".2");
        GroupLayout dataset2PaneLayout = new GroupLayout((Container)this.dataset2Pane);
        this.dataset2Pane.setLayout((LayoutManager)dataset2PaneLayout);
        dataset2PaneLayout.setHorizontalGroup((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(1).add((GroupLayout.Group)dataset2PaneLayout.createSequentialGroup().add((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(1).add((GroupLayout.Group)dataset2PaneLayout.createSequentialGroup().addContainerGap().add((Component)this.dataset2Label).addPreferredGap(0).add((Component)this.dataset2List, -2, -1, -2).addPreferredGap(0).add((Component)this.browse2Button)).add((GroupLayout.Group)dataset2PaneLayout.createSequentialGroup().add(51, 51, 51).add((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(1, false).add(2, (Component)this.suffix2Label).add(2, (Component)this.by23Label).add(2, (Component)this.by22Label).add(2, (Component)this.by21Label)).addPreferredGap(0).add((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(1).add((Component)this.suffix2Text, -2, 44, -2).add((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(1, false).add((Component)this.by23List, 0, -1, Short.MAX_VALUE).add((Component)this.by21List, 0, -1, Short.MAX_VALUE).add((GroupLayout.Group)dataset2PaneLayout.createSequentialGroup().add((Component)this.byall2Check).add(67, 67, 67)).add((Component)this.by22List, 0, -1, Short.MAX_VALUE))))).addContainerGap(-1, Short.MAX_VALUE)));
        dataset2PaneLayout.linkSize(new Component[]{this.byall2Check, this.suffix2Text}, 1);
        dataset2PaneLayout.setVerticalGroup((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(1).add((GroupLayout.Group)dataset2PaneLayout.createSequentialGroup().add((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(3).add((Component)this.dataset2Label).add((Component)this.dataset2List, -2, -1, -2).add((Component)this.browse2Button)).addPreferredGap(1).add((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(3).add((Component)this.by21List, -2, -1, -2).add((Component)this.by21Label)).addPreferredGap(0).add((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(3).add((Component)this.by22Label).add((Component)this.by22List, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(3).add((Component)this.by23List, -2, -1, -2).add((Component)this.by23Label)).add(7, 7, 7).add((Component)this.byall2Check).addPreferredGap(0).add((GroupLayout.Group)dataset2PaneLayout.createParallelGroup(1).add((Component)this.suffix2Label).add((Component)this.suffix2Text, -2, 19, -2)).addContainerGap(26, Short.MAX_VALUE)));
        GroupLayout datasetPaneLayout = new GroupLayout((Container)this.datasetPane);
        this.datasetPane.setLayout((LayoutManager)datasetPaneLayout);
        datasetPaneLayout.setHorizontalGroup((GroupLayout.Group)datasetPaneLayout.createParallelGroup(1).add((GroupLayout.Group)datasetPaneLayout.createSequentialGroup().add((Component)this.dataset1Pane, -2, -1, -2).addPreferredGap(0).add((Component)this.dataset2Pane, -2, -1, -2)));
        datasetPaneLayout.setVerticalGroup((GroupLayout.Group)datasetPaneLayout.createParallelGroup(1).add((Component)this.dataset2Pane, -1, -1, Short.MAX_VALUE).add((Component)this.dataset1Pane, -2, -1, -2));
        this.savePane.setBorder(BorderFactory.createTitledBorder("Save Options"));
        this.sortCheck.setText("Sort Output Data");
        this.sortCheck.setToolTipText("If selected, merged data will be sorted based on the columns used for merging.  If not selected, rows remain in order of dataset 1, with non-intersecting rows coming at the end, dataset 1 before dataset 2.");
        this.sortCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sortCheck.setMargin(new Insets(0, 0, 0, 0));
        this.rSaveLabel.setText("Local Name:");
        this.rSaveLabel.setToolTipText("This sets the variable name in R (and thus how the name will appear in the dataset lists).");
        this.rNameText.setText("mergedData");
        this.rNameText.setPreferredSize(new Dimension(120, 20));
        this.saveCheck.setSelected(true);
        this.saveCheck.setText("Save to File");
        this.saveCheck.setToolTipText("If checked, the merged dataset will be written out as a tab-delimited text file to the location specified below.");
        this.saveCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveCheck.setMargin(new Insets(0, 0, 0, 0));
        this.saveCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.saveCheckActionPerformed(evt);
            }
        });
        this.saveLabel.setText("Save filename:");
        this.saveLabel.setToolTipText("Name (and path) under which to save the merged file.  A .txt extension is recommended, since the output will be tab-delimited text.");
        this.nameText.setText("mergedData.txt");
        this.nameText.setPreferredSize(new Dimension(120, 20));
        this.outputBrowse.setText("Browse...");
        this.outputBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.outputBrowseActionPerformed(evt);
            }
        });
        GroupLayout savePaneLayout = new GroupLayout((Container)this.savePane);
        this.savePane.setLayout((LayoutManager)savePaneLayout);
        savePaneLayout.setHorizontalGroup((GroupLayout.Group)savePaneLayout.createParallelGroup(1).add((GroupLayout.Group)savePaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)savePaneLayout.createParallelGroup(1).add((GroupLayout.Group)savePaneLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.saveLabel).addPreferredGap(0).add((Component)this.nameText, -1, 169, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.outputBrowse).addContainerGap()).add((GroupLayout.Group)savePaneLayout.createSequentialGroup().add((Component)this.rSaveLabel).addPreferredGap(0).add((Component)this.rNameText, -2, -1, -2).addContainerGap()).add((GroupLayout.Group)savePaneLayout.createSequentialGroup().add((Component)this.sortCheck, -1, 176, Short.MAX_VALUE).add(218, 218, 218)).add((GroupLayout.Group)savePaneLayout.createSequentialGroup().add((Component)this.saveCheck).addContainerGap(306, Short.MAX_VALUE)))));
        savePaneLayout.setVerticalGroup((GroupLayout.Group)savePaneLayout.createParallelGroup(1).add((GroupLayout.Group)savePaneLayout.createSequentialGroup().add((GroupLayout.Group)savePaneLayout.createParallelGroup(3).add((Component)this.rSaveLabel).add((Component)this.rNameText, -2, -1, -2)).addPreferredGap(0).add((Component)this.sortCheck).addPreferredGap(0).add((Component)this.saveCheck).addPreferredGap(0).add((GroupLayout.Group)savePaneLayout.createParallelGroup(3).add((Component)this.saveLabel).add((Component)this.outputBrowse).add((Component)this.nameText, -2, -1, -2)).addContainerGap(19, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.submitButton.setText("Submit");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.submitButtonActionPerformed(evt);
            }
        });
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataMergeDialog.this.helpButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPaneLayout = new GroupLayout((Container)this.buttonPane);
        this.buttonPane.setLayout((LayoutManager)buttonPaneLayout);
        buttonPaneLayout.setHorizontalGroup((GroupLayout.Group)buttonPaneLayout.createParallelGroup(1).add((GroupLayout.Group)buttonPaneLayout.createSequentialGroup().add(210, 210, 210).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.submitButton).addPreferredGap(0).add((Component)this.helpButton).addContainerGap(217, Short.MAX_VALUE)));
        buttonPaneLayout.setVerticalGroup((GroupLayout.Group)buttonPaneLayout.createParallelGroup(1).add((GroupLayout.Group)buttonPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)buttonPaneLayout.createParallelGroup(3).add((Component)this.submitButton).add((Component)this.helpButton).add((Component)this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.datasetPane, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(128, 128, 128).add((Component)this.savePane, -2, -1, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.buttonPane, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.datasetPane, -2, -1, -2).addPreferredGap(0).add((Component)this.savePane, -2, -1, -2).addPreferredGap(0, 7, Short.MAX_VALUE).add((Component)this.buttonPane, -2, -1, -2).addContainerGap()));
    }

    private void saveCheckActionPerformed(ActionEvent evt) {
        this.saveLabel.setEnabled(this.saveCheck.isSelected());
        this.nameText.setEnabled(this.saveCheck.isSelected());
        this.outputBrowse.setEnabled(this.saveCheck.isSelected());
    }

    private void outputBrowseActionPerformed(ActionEvent evt) {
        this.setTextUsingFileChooser(this.nameText, 0);
    }

    private void by23ListActionPerformed(ActionEvent evt) {
        this.updateValidity();
    }

    private void by22ListActionPerformed(ActionEvent evt) {
        this.updateValidity();
    }

    private void by21ListActionPerformed(ActionEvent evt) {
        this.updateValidity();
    }

    private void by13ListActionPerformed(ActionEvent evt) {
        this.updateValidity();
    }

    private void by12ListActionPerformed(ActionEvent evt) {
        this.updateValidity();
    }

    private void by11ListActionPerformed(ActionEvent evt) {
        this.updateValidity();
    }

    private void dataset2ListActionPerformed(ActionEvent evt) {
        this.refreshBy2List();
    }

    private void browse2ButtonActionPerformed(ActionEvent evt) {
        int dataLength = this.getDataset2List().getItemCount();
        String[] datasets = new String[dataLength];
        int n = this.getDataset2List().getItemCount();
        for (int i = 0; i < n; ++i) {
            datasets[i] = this.getDataset2List().getItemAt(i).toString();
        }
        String workingDir = RUtils.evalAsString("getwd()");
        JGRDataFileOpenDialog fileDialog = new JGRDataFileOpenDialog((Frame)JGR.MAINRCONSOLE, workingDir);
        fileDialog.grabFocus();
        String keep2 = "";
        Object[] newdatasets = RUtils.getDatasetList();
        int n2 = newdatasets.length;
        for (int i = 0; i < n2; ++i) {
            Boolean newone = true;
            String pkeep = newdatasets[i].toString();
            for (int j = 0; j < dataLength; ++j) {
                if (!pkeep.equals(datasets[j])) continue;
                newone = false;
                break;
            }
            if (!newone.booleanValue()) continue;
            keep2 = pkeep;
            break;
        }
        this.refreshDatasetLists(2, this.isDatasetListValid(1) ? this.getDataset1() : "", keep2);
        this.dataset2List.grabFocus();
    }

    private void browse1ButtonActionPerformed(ActionEvent evt) {
        int dataLength = this.getDataset1List().getItemCount();
        String[] datasets = new String[dataLength];
        int n = this.getDataset1List().getItemCount();
        for (int i = 0; i < n; ++i) {
            datasets[i] = this.getDataset1List().getItemAt(i).toString();
        }
        String workingDir = RUtils.evalAsString("getwd()");
        JGRDataFileOpenDialog fileDialog = new JGRDataFileOpenDialog((Frame)JGR.MAINRCONSOLE, workingDir);
        fileDialog.grabFocus();
        String keep1 = "";
        Object[] newdatasets = RUtils.getDatasetList();
        int n2 = newdatasets.length;
        for (int i = 0; i < n2; ++i) {
            Boolean newone = true;
            String pkeep = newdatasets[i].toString();
            for (int j = 0; j < dataLength; ++j) {
                if (!pkeep.equals(datasets[j])) continue;
                newone = false;
                break;
            }
            if (!newone.booleanValue()) continue;
            keep1 = pkeep;
            break;
        }
        this.refreshDatasetLists(1, keep1, this.isDatasetListValid(2) ? this.getDataset2() : "");
        this.dataset1List.grabFocus();
    }

    private void dataset1ListActionPerformed(ActionEvent evt) {
        this.refreshBy1List();
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        String cmd = "datamerge.JGR(x=" + this.getDataset1() + ", y=" + this.getDataset2() + ", by11=\"" + this.getSelectBy11List() + "\"" + ", by12=\"" + this.getSelectBy12List() + "\"" + ", by13=\"" + this.getSelectBy13List() + "\"" + ", by21=\"" + this.getSelectBy21List() + "\"" + ", by22=\"" + this.getSelectBy22List() + "\"" + ", by23=\"" + this.getSelectBy23List() + "\"" + ", all.x=" + String.valueOf(this.byall1Check.isSelected()).toUpperCase() + ", all.y=" + String.valueOf(this.byall2Check.isSelected()).toUpperCase() + ", suffixes=c(" + this.suffix1Text.getText() + "," + this.suffix2Text.getText() + ")" + ", rName=\"" + this.rNameText.getText() + "\"" + ", sort=" + String.valueOf(this.sortCheck.isSelected()).toUpperCase() + ", writeout=" + String.valueOf(this.saveCheck.isSelected()).toUpperCase() + ", outName=\"" + this.nameText.getText() + "\"" + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        String cmd = "CADStat.help('datamerge.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateValidity();
    }
}

