% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenoCropClass.R
\name{phenoCropClass}
\alias{phenoCropClass}
\title{phenoCropClass}
\usage{
phenoCropClass(x, y, z, match = FALSE)
}
\arguments{
\item{x}{A \emph{matrix} or \emph{data.frame}.}

\item{y}{A \emph{character} vector.}

\item{z}{A \emph{numeric} element. Default is 1.}

\item{match}{logical argument.}
}
\value{
A \emph{list} containing a set of reference profiles for each unique class in \emph{y}.
}
\description{
Spatially explicit and phenology driven classification scheme for cropland mapping.
}
\details{
{Correlates \emph{x} with each row in \emph{y}. The row in \emph{y} with the highest 
correlation is reported as the selected class. If \emph{match} is set to TRUE the function will 
use Dynamic Time Wrapping (DTW) \emph{x} and \emph{y} at each iteration. \emph{z} sets the temporal 
buffer used to search to matching data points. The final output is a \emph{data.frame} containing:
\itemize{
 \item{\emph{r2} - \eqn{R^{2}} between \emph{x} and each row \emph{y}.}
 \item{\emph{count} - Number of records used to estimate the \eqn{R^{2}}.}
 \item{\emph{max.interval} - Maximum gap between data points when NA values exist.}}}
}
\examples{
{

require(fieldRS)

# read reference profiles
data(referenceProfiles)

# target time series
x <- c(2200, 4500, 4600, 6400, 1600)
y <- referenceProfiles[,2:6]

# Perform classification
c <-phenoCropClass(x, y)
head(c)

}
}
\seealso{
\code{\link{analyseTS}} \code{\link{phenoCropVal}}
}
