% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_Stations}
\alias{create_Stations}
\title{Create Stations}
\usage{
create_Stations(
  Poly,
  Bathy,
  Depths,
  N = NA,
  Nauto = NA,
  dist = NA,
  Buf = 1000,
  ShowProgress = FALSE
)
}
\arguments{
\item{Poly}{single polygon inside which stations will be generated. May be created using \code{\link{create_Polys}}.}

\item{Bathy}{bathymetry raster with the appropriate \code{\link[CCAMLRGIS:CCAMLRp]{projection}}, such as \code{\link[CCAMLRGIS:SmallBathy]{this one}}.}

\item{Depths}{vector of depths. For example, if the depth strata required are 600 to 1000 and 1000 to 2000,
\code{Depths=c(-600,-1000,-2000)}.}

\item{N}{vector of number of stations required in each depth strata,
therefore \code{length(N)} must equal \code{length(Depths)-1}.}

\item{Nauto}{instead of specifying \code{N}, a number of stations proportional to the areas of the depth strata
may be created. \code{Nauto} is the maximum number of stations required in any depth stratum.}

\item{dist}{if desired, a distance constraint in nautical miles may be applied. For example, if \code{dist=2},
stations will be at least 2 nautical miles apart.}

\item{Buf}{distance in meters from isobaths. Useful to avoid stations falling on strata boundaries.}

\item{ShowProgress}{if set to \code{TRUE}, a progress bar is shown (\code{create_Stations} may take a while).}
}
\value{
Spatial object in your environment. Data within the resulting object contains the strata and stations
locations in both projected space ("x" and "y") and degrees of Latitude/Longitude.

To see the data contained in your spatial object, type: \code{View(MyStations@data)}.
}
\description{
Create random point locations inside a polygon and within bathymetry strata constraints.
A distance constraint between stations may also be used if desired.
}
\examples{
\donttest{


#First, create a polygon within which stations will be created

MyPolys=create_Polys(Input=PolyData,Densify=TRUE)
plot(MyPolys)
text(MyPolys$Labx,MyPolys$Laby,MyPolys$ID)
#Subsample MyPolys to only keep the polygon with ID 'one'
MyPoly=MyPolys[MyPolys$ID=='one',]
plot(MyPoly,col='green',add=TRUE)

#Second (optional), crop your bathymetry raster to match the extent of your polygon

BathyCroped=raster::crop(SmallBathy,MyPoly)


#Example 1: Set numbers of stations, no distance constraint

MyStations=create_Stations(Poly=MyPoly,
           Bathy=BathyCroped,Depths=c(-550,-1000,-1500,-2000),N=c(20,15,10))
Mypar=par(mai=c(0,0,0,2)) #Figure margins as c(bottom, left, top, right)
plot(BathyCroped,breaks=Depth_cuts, col=Depth_cols, legend=FALSE,axes=FALSE,box=FALSE)
add_Cscale(offset = 50,height = 90,fontsize = 0.8,width=25)
plot(MyPoly,add=TRUE,border='red',lwd=2)
raster::contour(BathyCroped,levels=c(-550,-1000,-1500,-2000),add=TRUE)
plot(MyStations,add=TRUE,col='orange')
par(Mypar)

#Example 2: Set numbers of stations, with distance constraint
 
MyStations=create_Stations(Poly=MyPoly,
           Bathy=BathyCroped,Depths=c(-550,-1000,-1500,-2000),N=c(20,15,10),dist=10)
Mypar=par(mai=c(0,0,0,2)) #Figure margins as c(bottom, left, top, right)
plot(BathyCroped,breaks=Depth_cuts, col=Depth_cols, legend=FALSE,axes=FALSE,box=FALSE)
add_Cscale(offset = 50,height = 90,fontsize = 0.8,width=25)
plot(MyPoly,add=TRUE,border='red',lwd=2)
raster::contour(BathyCroped,levels=c(-550,-1000,-1500,-2000),add=TRUE)
plot(MyStations[MyStations$Stratum=='550-1000',],pch=21,bg='yellow',add=TRUE)
plot(MyStations[MyStations$Stratum=='1000-1500',],pch=21,bg='orange',add=TRUE)
plot(MyStations[MyStations$Stratum=='1500-2000',],pch=21,bg='red',add=TRUE)
par(Mypar)

#Example 3: Automatic numbers of stations, with distance constraint

MyStations=create_Stations(Poly=MyPoly,
           Bathy=BathyCroped,Depths=c(-550,-1000,-1500,-2000),Nauto=30,dist=10)
Mypar=par(mai=c(0,0,0,2)) #Figure margins as c(bottom, left, top, right)
plot(BathyCroped,breaks=Depth_cuts, col=Depth_cols, legend=FALSE,axes=FALSE,box=FALSE)
add_Cscale(offset = 50,height = 90,fontsize = 0.8,width=25)
plot(MyPoly,add=TRUE,border='red',lwd=2)
raster::contour(BathyCroped,levels=c(-550,-1000,-1500,-2000),add=TRUE)
plot(MyStations[MyStations$Stratum=='550-1000',],pch=21,bg='yellow',add=TRUE)
plot(MyStations[MyStations$Stratum=='1000-1500',],pch=21,bg='orange',add=TRUE)
plot(MyStations[MyStations$Stratum=='1500-2000',],pch=21,bg='red',add=TRUE)
par(Mypar)

}

}
\seealso{
\code{\link{create_Polys}}, \code{\link{SmallBathy}}, \code{\link{add_RefGrid}}.
}
