% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_pvalues}
\alias{get_pvalues}
\title{P-value Calculation Based on Null Distribution and Test Statistic}
\usage{
get_pvalues(
  dist,
  test_statistic,
  parametric = FALSE,
  tail = c("left", "right")
)
}
\arguments{
\item{dist}{Numeric vector. Represents the null distribution of the test statistic.}

\item{test_statistic}{Numeric. The observed test statistic for which the p-value is to be calculated.}

\item{parametric}{Logical. If TRUE, calculates parametric p-values assuming the null distribution is normal. If FALSE, calculates empirical p-values. Default is FALSE.}

\item{tail}{Character. Specifies whether to calculate left-tailed or right-tailed p-values. Must be either "left" or "right". Default is "left".}
}
\value{
Numeric. The calculated p-value.
}
\description{
This function calculates p-values based on the comparison of a test statistic against a null distribution. It can perform either empirical or parametric p-value calculations and supports both left-tailed and right-tailed tests.
}
\examples{
set.seed(123)
null_dist <- rnorm(1000)
observed_stat <- 1.5
p_value <- get_pvalues(null_dist, observed_stat, parametric = FALSE, tail = "right")
print(p_value)
}
