% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{computeQuery}
\alias{computeQuery}
\title{Execute dplyr query and save result in remote database}
\usage{
computeQuery(
  x,
  name = uniqueTableName(),
  temporary = TRUE,
  schema = NULL,
  overwrite = TRUE,
  ...
)
}
\arguments{
\item{x}{A dplyr query}

\item{name}{The name of the table to create.}

\item{temporary}{Should the table be temporary: TRUE (default) or FALSE}

\item{schema}{The schema where the table should be created. Ignored if
temporary = TRUE.}

\item{overwrite}{Should the table be overwritten if it already exists: TRUE (default)
or FALSE Ignored if temporary = TRUE.}

\item{...}{Further arguments passed on the \code{dplyr::compute}}
}
\value{
A \code{dplyr::tbl()} reference to the newly created table.
}
\description{
This function is a wrapper around \code{dplyr::compute} that is tested on several
database systems. It is needed to handle edge cases where \code{dplyr::compute}
does not produce correct SQL.
}
\examples{
\dontrun{
library(CDMConnector)

con <- DBI::dbConnect(duckdb::duckdb(), dbdir = eunomiaDir())
cdm <- cdmFromCon(con, "main")

# create a temporary table in the remote database from a dplyr query
drugCount <- cdm$concept \%>\%
  dplyr::count(domain_id == "Drug") \%>\%
  computeQuery()

# create a permanent table in the remote database from a dplyr query
drugCount <- cdm$concept \%>\%
  dplyr::count(domain_id == "Drug") \%>\%
  computeQuery("tmp_table", temporary = FALSE, schema = "main")

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
