% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fi_func_MLM.R
\name{Fi_func_MLM}
\alias{Fi_func_MLM}
\title{Generate Fisher information matrix F_x at a design point x_i for Multinomial logistic regression model}
\usage{
Fi_func_MLM(X_x, beta, link)
}
\arguments{
\item{X_x}{model matrix given design point x_i (for example, X_x = h.func(x_i), where h.func transforms a design point to a model matrix)}

\item{beta}{parameter coefficients in the Multinomial logistic regression model, the order of coefficients in bvec and the order of design points in X_x should be consistent}

\item{link}{link function of Multinomial logistic regression model, options are "baseline", "cumulative", "adjacent", or "continuation"}
}
\value{
F_x is the Fisher information matrix at design point x_i (with model matrix X_x);

U_x is a middle step matrix for calculation of F_x, details see Corollary 3.1 in Bu, X., Majumdar, D., & Yang, J. (2020). D-optimal designs for multinomial logistic models
}
\description{
Generate Fisher information matrix F_x at a design point x_i for Multinomial logistic regression model
}
\examples{
X_x_temp = rbind(c( 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
                c( 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0),
                c( 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
                c( 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0),
                c( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0))
bvec_temp = c(-4.047, -2.225, -0.302, 1.386, 4.214, 3.519,
2.420, 1.284, -0.131, -0.376, -0.237, -0.120)
link_temp = "cumulative"
Fi_func_MLM(X_x=X_x_temp, beta=bvec_temp, link=link_temp)
}
