% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.centers.R
\name{init.centers}
\alias{init.centers}
\title{Cluster Center Initialization}
\usage{
init.centers(x, k, method = c("kmeans++", "random"))
}
\arguments{
\item{x}{A numeric matrix of data. Each row corresponds to a distinct
observation; each column corresponds to a distinct variable/dimension. It
must not contain \code{NA} values.}

\item{k}{An integer indicating the number of cluster centers to initialize.}

\item{method}{A character string indicating the initialization method to use. 
It can take the following values:
\itemize{
 \item{"kmeans++": }{the centers are selected using the k-means++ algorithm.
  }
 \item{"random": }{the centers are randomly selected among the values in
  \code{x}}
}}
}
\value{
A matrix with \code{k} rows and \code{ncol(x)} columns.
}
\description{
\code{init.centers} automatically initializes the centers of the
 clusters before running the Cross-Entropy Clustering algorithm.
}
\examples{
## See the examples provided with the cec() function.

}
\references{
Arthur, D., & Vassilvitskii, S. (2007). k-means++: the advantages 
 of careful seeding. Proceedings of the Eighteenth Annual ACM-SIAM Symposium 
 on Discrete Algorithms, 1027–1035.
}
