% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cec.R
\name{plot.cec}
\alias{plot.cec}
\title{Plot CEC Objects}
\usage{
\method{plot}{cec}(
  x,
  col,
  cex = 0.5,
  pch = 19,
  cex.centers = 1,
  pch.centers = 8,
  ellipses = TRUE,
  ellipses.lwd = 4,
  ellipses.lty = 2,
  model = TRUE,
  xlab,
  ylab,
  ...
)
}
\arguments{
\item{x}{A \code{\link{cec}} object resulting from the \code{\link{cec}}
function.}

\item{col}{A specification for the default plotting color of the points in 
the clusters. See \code{\link{par}} for more details.}

\item{cex}{A numerical value giving the amount by which plotting text and 
symbols should be magnified relative to the default. See \code{\link{par}} 
for more details.}

\item{pch}{Either an integer specifying a symbol or a single character to be 
used as the default in plotting points. See \code{\link{par}} for more 
details.}

\item{cex.centers}{The same as \code{cex}, except that it applies only to the 
centers' means.}

\item{pch.centers}{The same as \code{pch}, except that it applies only to the 
centers' means.}

\item{ellipses}{If this parameter is TRUE, covariance ellipses will be drawn.}

\item{ellipses.lwd}{The line width of the covariance ellipses. See \code{lwd}
in \code{\link{par}} for more details.}

\item{ellipses.lty}{The line type of the covariance ellipses. See \code{lty}
in \code{\link{par}} for more details.}

\item{model}{If this parameter is TRUE, the model (expected) covariance will
be used for each cluster instead of the sample covariance (MLE) of the 
points in the cluster, when drawing the covariance ellipses.}

\item{xlab}{A label for the x axis. See \link{plot} for more details.}

\item{ylab}{A label for the y axis. See \link{plot} for more details.}

\item{...}{Additional arguments passed to \code{plot} when drawing data 
points.}
}
\value{
This function returns nothing.
}
\description{
\code{plot.cec} presents the results from the \code{\link{cec}}
 function in the form of a plot. The colors of the data points represent the
 cluster they belong to. Ellipses are drawn to represent the covariance
 (of either the model or the sample) of each cluster.
}
\examples{
## See the examples provided with the cec() function.

}
\seealso{
\code{\link{cec}}, \code{\link{print.cec}}
}
\keyword{hplot}
