#' Create a vulnerability map
#'
#' Extracts a vulnerability map of species habitat from a \code{vulnerability} object.
#'
#' @param vuln Object of class \code{vulnerability}

#' @details Note: this is only a convenience function. The \code{\link{vulnerability}}
#'   function creates a vulnerability map, and \code{vulnerability_map} simply extracts it.
#'   This is included for consistency with the \code{sensitivity_map} and
#'   \code{departure_map} functions.
#'
#' @examples
#' mod1 <- cnfa(x = climdat.hist, s.dat = ABPR, field = "CODE")
#' dep <- departure(x = climdat.hist, y = climdat.fut, s.dat = ABPR)
#' vuln <- vulnerability(cnfa = mod1, dep = dep)
#' vuln.map <- vulnerability_map(vuln)
#'
#' @return RasterLayer of vulnerability values
#'
#' @seealso \code{\link{vulnerability}}, \code{\link{sensitivity_map}}, \code{\link{exposure_map}}
#'
#' @export

vulnerability_map <- function(vuln) {
  vuln@ras
}
