% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lateonset.next.R
\name{lateonset.next}
\alias{lateonset.next}
\title{Determination of the dose level for next cohort in the calibration-free odds type (CFO-type) design with late-onset toxicity}
\usage{
lateonset.next(design, target, p.true, currdose, assess.window, enter.times, dlt.times, 
       current.t, doses, prior.para = list(alp.prior = target, bet.prior = 1 - target),
       cutoff.eli = 0.95, early.stop = 0.95)
}
\arguments{
\item{design}{option for selecting different designs, which can be set as \code{'TITE-CFO'}, \code{'TITE-aCFO'},
\code{'fCFO'}, \code{'f-aCFO'}, \code{'bCFO'}, and \code{'b-aCFO'}. Specifically, \code{'bCFO'} refers
to the benchmark CFO design, and \code{'b-aCFO'} denotes the benchmark aCFO design.}

\item{target}{the target DLT rate.}

\item{p.true}{the true DLT rates under the different dose levels.}

\item{currdose}{the current dose level.}

\item{assess.window}{the maximal assessment window size.}

\item{enter.times}{the time that each participant enters the trial.}

\item{dlt.times}{the time to DLT for each subject in the trial. If no DLT occurs for a subject,
\code{dlt.times} is set to 0.}

\item{current.t}{the current time.}

\item{doses}{the dose level for each subject in the trial.}

\item{prior.para}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of \code{cutoff.eli = 0.95} for general use.}

\item{early.stop}{the threshold value for early stopping. The default value \code{early.stop = 0.95}
generally works well.}
}
\value{
The \code{lateonset.next()} function returns
\itemize{
\item target: the target DLT rate.
\item decision: the decision in the CFO design, where \code{left}, \code{stay}, and \code{right} represent the
movement directions, and \code{stop} indicates stopping the experiment.
\item currdose: the current dose level.
\item nextdose: the recommended dose level for the next cohort.
\item overtox: the situation regarding which position experiences over-toxicity. The dose level indicated by
\code{overtox} and all the dose levels above experience over-toxicity. \code{overtox = NA} signifies that the
occurrence of over-toxicity did not happen.
\item over.doses: a vector indicating whether the dose level (from the first to last dose level) is over-toxic
or not (1 for yes).
}
}
\description{
The function is used to determine the next dose level in the CFO-type design with late-onset toxicity, specifically, including
time-to-event CFO (TITE-CFO) design, fractional CFO (fCFO) design, benchmark CFO design,
time-to-event accumulative CFO (TITE-aCFO) design, fractional accumulative CFO (f-aCFO) design
and benchmark aCFO design.
}
\details{
Late-onset outcomes commonly occur in phase I trials involving targeted agents or immunotherapies. The TITE
framework and fractional framework serve as two imputation methods to handle pending data
related to late-onset outcomes. This approach extends the CFO and aCFO designs to integrate time information
for delayed outcomes, leading to the development of TITE-CFO, fCFO, TITE-aCFO, and f-aCFO designs. \cr
In the TITE framework context, an assumption about the distribution of time to DLT must be pre-specified,
whereas the fractional framework does not require justification for a specific distribution of the time to
DLT. Consequently, fCFO and f-aCFO adapt to a more diverse range of scenarios.\cr
The function \code{lateonset.next()} also provides the option to execute
the benchmark CFO and benchmark aCFO design. These two methods await complete observation of toxicity outcomes for
the previous cohorts before determining the next dose assignment. This enhances precision but comes at the
expense of a prolonged trial duration.
}
\examples{
target <- 0.2; p.true <- c(0.01, 0.07, 0.20, 0.35, 0.50, 0.65, 0.80)
enter.times<- c(0, 0.266, 0.638, 1.54, 2.48, 3.14, 3.32, 4.01, 4.39, 5.38, 5.76,
               6.54, 6.66, 6.93, 7.32, 7.66, 8.14, 8.74)
dlt.times<- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0.610, 0, 2.98, 0, 0, 1.95, 0, 0, 1.48)
current.t<- 9.41
doses<-c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 3, 3, 3, 4, 4, 4)
## determine the dose level for the next cohort using the TITE-CFO design
decision <- lateonset.next(design = 'TITE-CFO', target, p.true, currdose = 4, assess.window = 3,   
               enter.times, dlt.times, current.t, doses)
summary(decision)
## determine the dose level for the next cohort using the TITE-aCFO design
decision <- lateonset.next(design = 'TITE-aCFO', target, p.true, currdose = 4, assess.window = 3,   
               enter.times, dlt.times, current.t, doses)
summary(decision)
## determine the dose level for the next cohort using the f-CFO design
decision <- lateonset.next(design = 'fCFO', target, p.true, currdose = 4, assess.window = 3,  
               enter.times, dlt.times, current.t, doses)
summary(decision)
## determine the dose level for the next cohort using the f-aCFO design
decision <- lateonset.next(design = 'f-aCFO', target, p.true, currdose = 4, assess.window = 3,   
               enter.times, dlt.times, current.t, doses)
summary(decision)
## determine the dose level for the next cohort using the benchmark CFO design
decision <- lateonset.next(design = 'bCFO', target, p.true, currdose = 4, assess.window = 3,   
               enter.times, dlt.times, current.t, doses)
summary(decision)
## determine the dose level for the next cohort using the benchmark aCFO design
decision <- lateonset.next(design='b-aCFO', target, p.true, currdose = 4, assess.window = 3,   
               enter.times, dlt.times, current.t, doses)
summary(decision)

}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
Jin H, Yin G (2023). Time‐to‐event calibration‐free odds design: A robust efficient design for
phase I trials with late‐onset outcomes. \emph{Pharmaceutical Statistics}, 22(5), 773–783.\cr
Yin G, Zheng S, Xu J (2013). Fractional dose-finding methods with late-onset toxicity in
phase I clinical trials. \emph{Journal of Biopharmaceutical Statistics}, 23(4), 856-870.\cr
Fang J, Yin G (2024). Fractional accumulative calibration‐free odds (f‐aCFO) design for delayed toxicity
in phase I clinical trials. \emph{Statistics in Medicine}.
}
\author{
Jialu Fang, Wenliang Wang, and Guosheng Yin
}
