% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFutils.R
\name{month_days}
\alias{month_days}
\title{Return the number of days in a month given a certain CF calendar}
\usage{
month_days(cf, x = NULL)
}
\arguments{
\item{cf}{CFtime. The CFtime definition to use.}

\item{x}{character. An optional vector of dates as strings with format
\code{YYYY-MM-DD}. Any time part will be silently ingested.}
}
\value{
A vector indicating the number of days in each month for the vector
of dates supplied as a parameter to the function. If no dates are supplied,
the number of days per month for the calendar as a vector of length 12.
Invalidly specified dates will result in an \code{NA} value.
}
\description{
Given a vector of dates as strings in ISO 8601 or UDUNITS format and a \code{CFtime} object,
this function will return a vector of the same length as the dates,
indicating the number of days in the month according to the calendar
specification. If no vector of days is supplied, the function will return an
integer vector of length 12 with the number of days for each month of the
calendar (disregarding the leap day for \code{standard} and \code{julian} calendars).
}
\examples{
dates <- c("2021-11-27", "2021-12-10", "2022-01-14", "2022-02-18")
cf <- CFtime("days since 1850-01-01", "standard")
month_days(cf, dates)

cf <- CFtime("days since 1850-01-01", "360_day")
month_days(cf, dates)

cf <- CFtime("days since 1850-01-01", "all_leap")
month_days(cf, dates)

month_days(cf)
}
\seealso{
When working with factors generated by \code{\link[=CFfactor]{CFfactor()}}, it is usually
better to use \code{\link[=CFfactor_units]{CFfactor_units()}} as that will consider leap days for
non-epoch factors. \code{\link[=CFfactor_units]{CFfactor_units()}} can also work with other time periods
and datum units, such as "hours per month", or "days per season".
}
