% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPplotblockselection}
\alias{CGGPplotblockselection}
\title{Plot CGGP block selection over time}
\usage{
CGGPplotblockselection(CGGP, indims)
}
\arguments{
\item{CGGP}{CGGP object}

\item{indims}{Which input dimensions should be shown?}
}
\value{
ggplot2 object
}
\description{
Shows the order in which blocks were selected
for each dimension.
Gives an idea of how the selections change over time.
}
\examples{
gs <- CGGPcreate(d=3, batchsize=100)
# All dimensions will look similar
CGGPplotblockselection(gs)
\donttest{
# You need to append with CGGPappend after fitting to see a difference
f <- function(x){x[1]^1.2}
y <- apply(gs$design, 1, f)
gs <- CGGPfit(gs, Y=y)
gs <- CGGPappend(gs, 100)
# Now you will see higher for X1 from 100 to 200 while others remain low.
CGGPplotblockselection(gs)
}
}
