% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeRVmat.R
\name{computeRVmat}
\alias{computeRVmat}
\title{Compute modified RV matrix}
\usage{
computeRVmat(DataList = DataList, dist = TRUE, verbose = TRUE)
}
\arguments{
\item{DataList}{a list with matrices}

\item{dist}{boolean if TRUE distance object is returned}

\item{verbose}{boolean if TRUE progressbar is printed to the console}
}
\value{
\item{RVsS}{a square similarity matrix of \code{class} \code{\link{matrix}} or distance object of \code{class} \code{\link{dist}} containing the pairwise modified RV values}
}
\description{
This function computes a NxN modified RV matrix
}
\examples{

\dontrun{
CICA_data <- Sim_CICA(Nr = 15, Q = 5, R = 4, voxels = 100, timepoints = 10,
E = 0.4, overlap = .25, externalscore = TRUE)
#Compute single subject ICAs (nClus equals length(ExampleData))
output <- CICA(DataList = CICA_data$X, nStarts = 1,
               nComp = 5, nClus = 9, verbose = FALSE)

RV <- computeRVmat(DataList = output$Sr, dist = TRUE,
                    verbose = FALSE)

# apply hierarchical clustering on RV output
hcl <- hclust(RV)
plot(hcl)

# low dimensional visualisation using Classical Multidimensional Scaling
mds <- cmdscale(RV)
plot(mds)
}

}
