% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeInitialClusters.R
\name{mergeInitialClusters}
\alias{mergeInitialClusters}
\title{Merge Initial Clusters}
\usage{
mergeInitialClusters(
  seu_list,
  dist_list,
  use = "coef",
  method = "hc",
  hc.method = "average",
  cutree.by = "h",
  cutree.h = 0.6,
  cutree.k = 3,
  batch.var = "Batch"
)
}
\arguments{
\item{seu_list}{A list of Seurat objects containing the single-cell data. This parameter is required.}

\item{dist_list}{A list of similarity matrices as returned by \code{getDistMat()}. The order of matrices
should correspond to that of the Seurat objects in \code{seu_list}.}

\item{use}{A string specifying the similarity measure to use. Currently, only "coef" is supported. Default is "coef".}

\item{method}{A string specifying the clustering method to employ. The default is "hc" for hierarchical clustering.}

\item{hc.method}{A string passed to the \code{method} parameter of \code{hclust()}. Default is "average".}

\item{cutree.by}{A character indicating whether to cut the dendrogram by height ("h", default) or by
a set number of clusters ("k").}

\item{cutree.h}{A numeric value defining the height at which to cut the tree if \code{cutree.by = "h"}. Default is 0.6.}

\item{cutree.k}{A numeric value specifying the number of clusters to generate if \code{cutree.by = "k"}. Default is 3.}

\item{batch.var}{A character string representing the metadata column name that contains batch information.
Default is "Batch".}
}
\value{
A list of Seurat objects in which the initial clustering has been updated. The new cluster
assignments are stored in the \code{inicluster} field of each Seurat object, whilst the original
assignments are preserved in the \code{inicluster_tmp} field.
}
\description{
Merge initial clusters based on a provided similarity matrix and hierarchical clustering.
}
\details{
This function accepts a list of Seurat objects and a corresponding list of similarity matrices,
and then merges the initial clusters using a hierarchical clustering approach. The updated cluster
assignments are stored within each Seurat object.
}
\seealso{
\code{\link{gatherInitialClusters}}, \code{\link{initialClustering}}
}
