\name{CITAN-package}
\title{CITation ANalysis toolpack}
\description{CITAN is a library of functions useful in --- but not limited to ---
quantitative research in the field of scientometrics.
It also contains various methods for dealing with the Pareto-type II distribution.}
\details{Fair and objective assessment methods of individual scientists
had become the focus of scientometricians' attention since the
very beginning of their discipline. A quantitative expression
of some publication-citation process
characteristics is assumed to be a predictor of broadly conceived
scientific competence.

Among the most popular scientific impact indicators is the
\eqn{h}-index, proposed by J. Hirsch (2005).
It has been defined as follows. An author who had published \eqn{n}
papers has the Hirsch index equal to \eqn{H}, if each of his \eqn{H}
publications were cited at least \eqn{H} times, and each of the
other \eqn{n-H} items were cited no more than \eqn{H} times. This simple
bibliometric indicator
quickly received much attention in the academic community
and started to be a subject of intensive
research. It was noted that contrary to earlier approaches,
i.e. publication count, citation count etc.,
this measure both concerns productivity and impact of an
individual.

In a broader perspective, this issue is a special case
of the so-called Producer Assessment Problem (Gagolewski, Grzegorzewski, 2010b).
Its main aim is to analyze (both theoretically and empirically)
a special class of aggregation
operators (see Grabisch et al, 2009) called impact functions.

The CITAN package consists of three types of tools.
Given a numeric vector, the first class of functions computes the values
of certain impact functions.
Among them are:
\enumerate{
\item Hirsch's \eqn{h}-index (Hirsch, 2005; see \code{\link{index.h}}),
\item Egghe's \eqn{g}-index (Egghe, 2006; see \code{\link{index.g}}),
\item the \eqn{r_p} and \eqn{l_p} indices (Gagolewski, Grzegorzewski, 2009a, 2009b;
see \code{\link{index.rp}} and \code{\link{index.lp}}), which
generalize the \eqn{h}-index and the \eqn{w}-index (Woeginger, 2008), and
\item S-statistics (Gagolewski, Grzegorzewski, 2010a, 2011;
see \code{\link{Sstat}} and \code{\link{Sstat2}}),
which generalize the OWMax operators (Dubois et al, 1988)
and the \eqn{h}- and \eqn{r_\infty}-indices.
}

Additionally, a set of functions dealing with stochastic aspects
of the class of S-statistics and the Pareto type-II family of distributions
is included (Gagolewski, Grzegorzewski, 2010a). We have the following.
The functions that work for any continuous distribution (see Gagolewski, Grzegorzewski, 2010a):
\enumerate{
\item \code{\link{psstat}}, \code{\link{dsstat}} for computing the distribution of S-statistics
generated by a control function,
\item \code{\link{phirsch}}, \code{\link{dhirsch}} for computing the distribution of the Hirsch index,
\item \code{\link{rho.get}} for computing the so-called \eqn{\kappa}-index (\eqn{\rho_\kappa}),
which is a particular location characteristic of a given probability distribution
depending on a control function \eqn{\kappa}.
}
Tools for the Pareto-type II family:
\enumerate{
\item \code{\link{ppareto2}}, \code{\link{dpareto2}}, \code{\link{qpareto2}}, \code{\link{rpareto2}}
for general functions dealing with the Pareto distribution of the second kind,
including the c.d.f., p.d.f, quantiles and random deviates,
\item \code{\link{pareto2.htest}} --- two-sample \eqn{h}-test for equality of shape parameters based on the difference of \eqn{h}-indices,
\item \code{\link{pareto2.htest.approx}} --- two-sample asymptotic (approximate) \eqn{h}-test,
\item \code{\link{pareto2.ftest}} --- two-sample exact F-test for equality of shape parameters,
\item \code{\link{pareto2.zsestimate}} --- estimation of parameters using the Bayesian method (MMSE) developed by Zhang and Stevens (2009),
\item \code{\link{pareto2.mlekestimate}} --- estimation of shape parameter using the unbiased MLE,
\item \code{\link{pareto2.goftest}} --- goodness-of-fit tests,
\item \code{\link{pareto2.confint.rho}} and \code{\link{pareto2.confint.rho.approx}} --- exact and approximate (asymptotic)
confidence intervals for the \eqn{\kappa}-index basing on S-statistics,
\item \code{\link{pareto2.confint.h}} --- exact confidence intervals for the theoretical \eqn{h}-index.
}

Moreover, we have implemented some simple graphical methods than may be used
to illustrate various aspects of data being analyzed,
see \code{\link{plot.citfun}}, \code{\link{curve.add.rp}}, and \code{\link{curve.add.lp}}.




Please feel free to send any comments and suggestions (e.g.
to include some new bibliometric impact indices) to the author
(see also \url{http://www.ibspan.waw.pl/~gagolews}).

For a complete list of functions, use \code{library(help="CITAN")}.

Keywords: Hirsch's h-index, Egghe's g-index, L-statistics, S-statistics, bibliometrics, scientometrics, informetrics,
webometrics, aggregation operators, impact functions, impact assessment.}
\alias{CITAN}
\docType{package}
\author{Marek Gagolewski \email{gagolews@ibspan.waw.pl}}
\references{Dubois D., Prade H., Testemale C., Weighted fuzzy pattern matching, Fuzzy Sets and Systems 28, s. 313-331, 1988.\cr
Egghe L., Theory and practise of the g-index, Scientometrics 69(1), 131-152, 2006.\cr
Gagolewski M., Grzegorzewski P., Possibilistic analysis of arity-monotonic aggregation operators and its relation to bibliometric impact assessment of individuals, International Journal of Approximate Reasoning, doi:10.1016/j.ijar.2011.01.010.\cr
Gagolewski M., Grzegorzewski P., A geometric approach to the construction of scientific impact indices, Scientometrics 81(3), 2009a, 617-634.\cr
Gagolewski M., Debski M., Nowakiewicz M., Efficient algorithms for computing ''geometric'' scientific impact indices, Research Report of Systems Research Institute, Polish Academy of Sciences RB/1/2009, 2009b.\cr
Gagolewski M., Grzegorzewski P., S-statistics and their basic properties, In: Borgelt C. et al (Eds.), Combining Soft Computing and Statistical Methods in Data Analysis, Springer-Verlag, 2010a, 281-288.\cr
Grabisch M., Pap E., Marichal J.-L., Mesiar R.. Aggregation functions, Cambridge, 2009.\cr
Hirsch J.E., An index to quantify individual's scientific research output, Proceedings of the National Academy of Sciences 102(46), 16569-16572, 2005.\cr
Kosmulski M., MAXPROD - A new index for assessment of the scientific output of an individual, and a comparison with the h-index, Cybermetrics 11(1), 2007.\cr
Woeginger G.J., An axiomatic characterization of the Hirsch-index, Mathematical Social Sciences 56(2), 224-232, 2008.\cr
Zhang J., Stevens M.A., A New and Efficient Estimation Method for the Generalized Pareto Distribution, Technometrics 51(3), 2009, 316-325.\cr}
