% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clme_resids.r
\name{clme_resids}
\alias{clme_resids}
\title{Computes various types of residuals}
\usage{
clme_resids(formula, data, gfix = NULL)
}
\arguments{
\item{formula}{a formula expression. The constrained effect(s) must come before any unconstrained covariates on the right-hand side of the expression. The first \code{ncon} terms will be assumed to be constrained.}

\item{data}{data frame containing the variables in the model.}

\item{gfix}{optional vector of group levels for residual variances. Data should be sorted by this value.}
}
\value{
List containing the elements \code{PA}, \code{SS}, \code{FM}, \code{cov.theta}, \code{xi}, \code{ssq}, \code{tsq}.
\code{PA}, \code{SS}, \code{FM} are defined above (for fixed-effects models, the residuals are only \code{PA}). Then \code{cov.theta} is the unconstrained covariance matrix of the fixed-effects coefficients, \code{xi} is the vector of random effect estimates, and \code{ssq} and \code{tsq} are unconstrained estimates of the variance components.
}
\description{
Computes several types of residuals for objects of class \code{clme}.
}
\details{
For fixed-effects models \eqn{Y = X\beta + \epsilon}{Y = X*b + e}, residuals are given as \eqn{\hat{e} = Y - X\hat{\beta}}{ ehat = Y - X*betahat}.
For mixed-effects models \eqn{Y = X\beta + + U\xi + \epsilon}{Y = X*b + U*xi + e}, three types of residuals are available.
\eqn{PA = Y - X\hat{\beta}}{ PA = Y - X*betahat}\\
\eqn{SS = U\hat{\xi}}{ SS = U*xihat}\\
\eqn{FM = Y - X\hat{\beta} - U\hat{\xi}}{ FM = Y - X*betahat - U*xihat}
}
\note{
There are few error catches in these functions. If only the EM estimates are desired, 
users are recommended to run \code{\link{clme}} setting \code{nsim=0}.

By default, homogeneous variances are assumed for the residuals and (if included) 
random effects. Heterogeneity can be induced using the arguments \code{Nks} and \code{Qs},
 which refer to the vectors \eqn{ (n_{1}, n_{2}, \ldots, n_{k}) }{(n1, n2 ,... , nk)} and
  \eqn{ (c_{1}, c_{2}, \ldots, c_{q}) }{(c1, c2 ,... , cq)}, respectively. See 
  \code{\link{CLME-package}} for further explanation the model and these values.

See \code{\link{w.stat}} and \code{\link{lrt.stat}} for more details on using custom 
test statistics.
}
\examples{
\dontrun{
data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )

clme.out <- clme_resids(mcv ~ time + temp + sex + (1|id), data = rat.blood )
}

}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}
