% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ggomnbd_PAlive}
\alias{ggomnbd_PAlive}
\alias{ggomnbd_staticcov_PAlive}
\alias{ggomnbd_nocov_PAlive}
\title{GGompertz/NBD: Probability of Being Alive}
\usage{
ggomnbd_staticcov_PAlive(
  r,
  alpha_0,
  b,
  s,
  beta_0,
  vX,
  vT_x,
  vT_cal,
  vCovParams_trans,
  vCovParams_life,
  mCov_life,
  mCov_trans
)

ggomnbd_nocov_PAlive(r, alpha_0, b, s, beta_0, vX, vT_x, vT_cal)
}
\arguments{
\item{r}{shape parameter of the Gamma distribution of the purchase process.
The smaller r, the stronger the heterogeneity of the purchase process.}

\item{alpha_0}{scale parameter of the Gamma distribution of the purchase process.}

\item{b}{scale parameter of the Gompertz distribution (constant across customers)}

\item{s}{shape parameter of the Gamma distribution for the lifetime process
The smaller s, the stronger the heterogeneity of customer lifetimes.}

\item{beta_0}{scale parameter for the Gamma distribution for the lifetime process}

\item{vX}{Frequency vector of length n counting the numbers of purchases.}

\item{vT_x}{Recency vector of length n.}

\item{vT_cal}{Vector of length n indicating the total number of periods of observation.}

\item{vCovParams_trans}{Vector of estimated parameters for the transaction covariates.}

\item{vCovParams_life}{Vector of estimated parameters for the lifetime covariates.}

\item{mCov_life}{Matrix containing the covariates data affecting the lifetime process. One column for each covariate.}

\item{mCov_trans}{Matrix containing the covariates data affecting the transaction process. One column for each covariate.}
}
\value{
Returns a vector with the PAlive for each customer.
}
\description{
Calculates the probability of a customer being alive at the end of the calibration period,
based on a customer's past transaction behavior and the GGompertz/NBD model parameters.

\describe{
\item{\code{ggomnbd_nocov_PAlive}}{ P(alive) for the GGompertz/NBD model without covariates}
\item{\code{ggomnbd_staticcov_PAlive}}{ P(alive) for the GGompertz/NBD model with static covariates}
}
}
\details{
\code{mCov_trans} is a matrix containing the covariates data of
the time-invariant covariates that affect the transaction process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_trans} at the respective position.

\code{mCov_life} is a matrix containing the covariates data of
the time-invariant covariates that affect the lifetime process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_life} at the respective position.
}
\references{
Bemmaor AC, Glady N (2012). \dQuote{Modeling Purchasing Behavior with Sudden \dQuote{Death}: A Flexible Customer
Lifetime Model} Management Science, 58(5), 1012-1021.

Adler J (2022).  \dQuote{Comment on “Modeling Purchasing Behavior with Sudden \dQuote{Death}: A Flexible Customer
Lifetime Model} Management Science 69(3):1929-1930.

The expression for the PMF was derived by Adler J (2024). (unpublished)
}
