% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ggomnbd_CET}
\alias{ggomnbd_CET}
\alias{ggomnbd_nocov_CET}
\alias{ggomnbd_staticcov_CET}
\title{GGompertz/NBD: Conditional Expected Transactions}
\usage{
ggomnbd_nocov_CET(r, alpha_0, b, s, beta_0, dPeriods, vX, vT_x, vT_cal)

ggomnbd_staticcov_CET(
  r,
  alpha_0,
  b,
  s,
  beta_0,
  dPeriods,
  vX,
  vT_x,
  vT_cal,
  vCovParams_trans,
  vCovParams_life,
  mCov_life,
  mCov_trans
)
}
\arguments{
\item{r}{shape parameter of the Gamma distribution of the purchase process.
The smaller r, the stronger the heterogeneity of the purchase process.}

\item{alpha_0}{scale parameter of the Gamma distribution of the purchase process.}

\item{b}{scale parameter of the Gompertz distribution (constant across customers)}

\item{s}{shape parameter of the Gamma distribution for the lifetime process
The smaller s, the stronger the heterogeneity of customer lifetimes.}

\item{beta_0}{scale parameter for the Gamma distribution for the lifetime process}

\item{dPeriods}{number of periods to predict}

\item{vX}{Frequency vector of length n counting the numbers of purchases.}

\item{vT_x}{Recency vector of length n.}

\item{vT_cal}{Vector of length n indicating the total number of periods of observation.}

\item{vCovParams_trans}{Vector of estimated parameters for the transaction covariates.}

\item{vCovParams_life}{Vector of estimated parameters for the lifetime covariates.}

\item{mCov_life}{Matrix containing the covariates data affecting the lifetime process. One column for each covariate.}

\item{mCov_trans}{Matrix containing the covariates data affecting the transaction process. One column for each covariate.}
}
\value{
Returns a vector containing the conditional expected transactions for the existing
customers in the GGompertz/NBD model.
}
\description{
Calculates the expected number of transactions in a given time period based
on a customer's past transaction behavior and the GGompertz/NBD model parameters.

\itemize{
\item{\code{ggomnbd_nocov_CET}}{ Conditional Expected Transactions without covariates}
\item{\code{ggomnbd_staticcov_CET}}{ Conditional Expected Transactions with static covariates}
}
}
\details{
\code{mCov_trans} is a matrix containing the covariates data of
the time-invariant covariates that affect the transaction process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_trans} at the respective position.

\code{mCov_life} is a matrix containing the covariates data of
the time-invariant covariates that affect the lifetime process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_life} at the respective position.
}
\references{
Bemmaor AC, Glady N (2012). \dQuote{Modeling Purchasing Behavior with Sudden \dQuote{Death}: A Flexible Customer
Lifetime Model} Management Science, 58(5), 1012-1021.
}
