% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.CC_funcs.R
\name{get.cqt.from.aggfinal}
\alias{get.cqt.from.aggfinal}
\title{Get cqt file from final aggregated results for plotting, based on the
long-formatted final results}
\usage{
get.cqt.from.aggfinal(
  dt_long,
  output_dir,
  mcmc.meta_filename = "mcmc.meta.rda"
)
}
\arguments{
\item{dt_long}{final results in long format}

\item{output_dir}{where to find the "mcmc.meta.rda"}

\item{mcmc.meta_filename}{default to "mcmc.meta.rda"}
}
\value{
res.cqt.Lw.new
}
\description{
Get cqt file from final aggregated results for plotting, based on the
long-formatted final results
}
\examples{
\dontrun{
dt_u5 <- get.CME.UI.data(dir_file = final_dir_list$dir_total_2020)
dt_u5 <- dt_u5[Indicator == "U5MR"]
output_dir <- file.path(get.IGMEoutput.dir(2019), "GR20200214_all")
res.cqt.Lw.new <- get.cqt.from.aggfinal(dt_u5, output_dir)
}

}
