% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_sub_cables.R
\name{financial_cof_sub_cables}
\alias{financial_cof_sub_cables}
\title{Financial cost of Failure for Sub cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
financial_cof_sub_cables(sub_cable_asset_category)
}
\arguments{
\item{sub_cable_asset_category}{String The type of Submarine cable asset category}
}
\value{
Numeric. Financial consequences of failure for Sub cables
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 75, CNAIM, 2017). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_sub_cables(sub_cable_asset_category = "HV Sub Cable")
}
