% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_switchgear_30_60kv.R
\name{environmental_cof_switchgear_30_60kv}
\alias{environmental_cof_switchgear_30_60kv}
\title{Environmental cost of Failure for 30kV and 60kV Switchgear}
\usage{
environmental_cof_switchgear_30_60kv(
  ehv_asset_category,
  type_env_factor,
  prox_water,
  bunded
)
}
\arguments{
\item{ehv_asset_category}{String The type of EHV asset category
Options: \code{ehv_asset_category = c("30kV", "60kV")}.}

\item{type_env_factor}{String The type environment factor of 30kV and 60kV switchgear
Options: \code{type_env_factor = c("Oil", "SF6", "Niether", "Default")}.}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}
}
\value{
Numeric. Financial consequences of failure for 30kV and 60kV switchgear
}
\description{
This function calculates environmental consequences of failure
Environmental consequences of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().#'
Outputted in DKK.
}
\examples{
environmental_cof_switchgear_30_60kv(ehv_asset_category = "30kV",
type_env_factor = "Oil",
prox_water = 95,
bunded = "Yes")
}
