% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dga_test_modifier.R
\name{dga_test_modifier}
\alias{dga_test_modifier}
\title{DGA Test Modifier}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
dga_test_modifier(
  hydrogen = "Default",
  methane = "Default",
  ethylene = "Default",
  ethane = "Default",
  acetylene = "Default",
  hydrogen_pre = "Default",
  methane_pre = "Default",
  ethylene_pre = "Default",
  ethane_pre = "Default",
  acetylene_pre = "Default"
)
}
\arguments{
\item{hydrogen}{Numeric. Refers to the hydrogen level in the
transformer oil. Hydrogen levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{methane}{Numeric. Refers to the methane level in the
transformer oil. Methane levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethylene}{Numeric. Refers to the ethylene level in the
transformer oil. Ethylene levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethane}{Numeric. Refers to the ethane level in the
transformer oil. Ethane levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{acetylene}{Numeric. Refers to the acetylene level in the
transformer oil. Acetylene levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{hydrogen_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{methane_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethylene_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethane_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{acetylene_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}
}
\value{
Data table.
}
\description{
This function calculates the DGA test modifier
for 33/10kV, 66/10kV and 132kV transformers. See e.g. section 6.12 on page
65 in CNAIM (2017).
}
\examples{
# DGA test modifier
dga_test_modifier(hydrogen = "Default",
methane = "Default",
ethylene = "Default",
ethane = "Default",
acetylene = "Default",
hydrogen_pre = "Default",
methane_pre = "Default",
ethylene_pre = "Default",
ethane_pre = "Default",
acetylene_pre = "Default")
}
