% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duty_factor_cables.R
\name{duty_factor_cables}
\alias{duty_factor_cables}
\title{Duty Factor for all cables (incl. submarine cables).}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
duty_factor_cables(
  utilisation_pct = "Default",
  operating_voltage_pct = "Default",
  voltage_level = "EHV"
)
}
\arguments{
\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{operating_voltage_pct}{Numeric. The ratio in percent of
operating/design voltage.}

\item{voltage_level}{String. Specify the voltage level. Options:
\code{voltage_level = c("EHV", "HV")}.
Choose \code{"EHV"} for cables \code{>= 33kV}  and \code{"HV"}
for cables \code{< 33kV} .}
}
\value{
Numeric. Duty factor for cables.
}
\description{
This function calculates the duty factor for under all types of
cables depending on the maximum
percentage utilisation under normal operating conditions.
The duty factor is used in the deriviation of the expected life of an asset.
See e.g. \code{\link{expected_life}()}. For more general information about
the derivation of the duty factor see section 6.6 on page 51 in CNAIM (2021)
}
\examples{
duty_factor_cables(utilisation_pct = "Default",
operating_voltage_pct = "Default",
voltage_level = "EHV")
}
