// Generated by rstantools.  Do not edit by hand.

/*
    CNVRG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CNVRG is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CNVRG.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_dm_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_dm");
    reader.add_event(29, 27, "end", "model_dm");
    return reader;
}
#include <stan_meta_header.hpp>
class model_dm
  : public stan::model::model_base_crtp<model_dm> {
private:
        int N;
        int nreps;
        int notus;
        std::vector<int> start;
        std::vector<int> end;
        std::vector<std::vector<int> > datamatrix;
public:
    model_dm(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_dm(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_dm_namespace::model_dm";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "nreps", "int", context__.to_vec());
            nreps = int(0);
            vals_i__ = context__.vals_i("nreps");
            pos__ = 0;
            nreps = vals_i__[pos__++];
            check_greater_or_equal(function__, "nreps", nreps, 1);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "notus", "int", context__.to_vec());
            notus = int(0);
            vals_i__ = context__.vals_i("notus");
            pos__ = 0;
            notus = vals_i__[pos__++];
            check_greater_or_equal(function__, "notus", notus, 1);
            current_statement_begin__ = 6;
            validate_non_negative_index("start", "N", N);
            context__.validate_dims("data initialization", "start", "int", context__.to_vec(N));
            start = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("start");
            pos__ = 0;
            size_t start_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < start_k_0_max__; ++k_0__) {
                start[k_0__] = vals_i__[pos__++];
            }
            size_t start_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < start_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "start[i_0__]", start[i_0__], 1);
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("end", "N", N);
            context__.validate_dims("data initialization", "end", "int", context__.to_vec(N));
            end = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("end");
            pos__ = 0;
            size_t end_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < end_k_0_max__; ++k_0__) {
                end[k_0__] = vals_i__[pos__++];
            }
            size_t end_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < end_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "end[i_0__]", end[i_0__], 1);
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("datamatrix", "nreps", nreps);
            validate_non_negative_index("datamatrix", "notus", notus);
            context__.validate_dims("data initialization", "datamatrix", "int", context__.to_vec(nreps,notus));
            datamatrix = std::vector<std::vector<int> >(nreps, std::vector<int>(notus, int(0)));
            vals_i__ = context__.vals_i("datamatrix");
            pos__ = 0;
            size_t datamatrix_k_0_max__ = nreps;
            size_t datamatrix_k_1_max__ = notus;
            for (size_t k_1__ = 0; k_1__ < datamatrix_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < datamatrix_k_0_max__; ++k_0__) {
                    datamatrix[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 13;
            validate_non_negative_index("theta", "N", N);
            num_params_r__ += (1 * N);
            current_statement_begin__ = 14;
            validate_non_negative_index("pi", "notus", notus);
            validate_non_negative_index("pi", "N", N);
            num_params_r__ += ((notus - 1) * N);
            current_statement_begin__ = 15;
            validate_non_negative_index("p", "notus", notus);
            validate_non_negative_index("p", "nreps", nreps);
            num_params_r__ += ((notus - 1) * nreps);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_dm() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 13;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "N", N);
        context__.validate_dims("parameter initialization", "theta", "double", context__.to_vec(N));
        std::vector<double> theta(N, double(0));
        size_t theta_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            theta[k_0__] = vals_r__[pos__++];
        }
        size_t theta_i_0_max__ = N;
        for (size_t i_0__ = 0; i_0__ < theta_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, theta[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 14;
        if (!(context__.contains_r("pi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable pi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("pi");
        pos__ = 0U;
        validate_non_negative_index("pi", "notus", notus);
        validate_non_negative_index("pi", "N", N);
        context__.validate_dims("parameter initialization", "pi", "vector_d", context__.to_vec(N,notus));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > pi(N, Eigen::Matrix<double, Eigen::Dynamic, 1>(notus));
        size_t pi_j_1_max__ = notus;
        size_t pi_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < pi_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < pi_k_0_max__; ++k_0__) {
                pi[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t pi_i_0_max__ = N;
        for (size_t i_0__ = 0; i_0__ < pi_i_0_max__; ++i_0__) {
            try {
                writer__.simplex_unconstrain(pi[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable pi: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 15;
        if (!(context__.contains_r("p")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        validate_non_negative_index("p", "notus", notus);
        validate_non_negative_index("p", "nreps", nreps);
        context__.validate_dims("parameter initialization", "p", "vector_d", context__.to_vec(nreps,notus));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > p(nreps, Eigen::Matrix<double, Eigen::Dynamic, 1>(notus));
        size_t p_j_1_max__ = notus;
        size_t p_k_0_max__ = nreps;
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                p[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t p_i_0_max__ = nreps;
        for (size_t i_0__ = 0; i_0__ < p_i_0_max__; ++i_0__) {
            try {
                writer__.simplex_unconstrain(p[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 13;
            std::vector<local_scalar_t__> theta;
            size_t theta_d_0_max__ = N;
            theta.reserve(theta_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < theta_d_0_max__; ++d_0__) {
                if (jacobian__)
                    theta.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    theta.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 14;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > pi;
            size_t pi_d_0_max__ = N;
            pi.reserve(pi_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < pi_d_0_max__; ++d_0__) {
                if (jacobian__)
                    pi.push_back(in__.simplex_constrain(notus, lp__));
                else
                    pi.push_back(in__.simplex_constrain(notus));
            }
            current_statement_begin__ = 15;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > p;
            size_t p_d_0_max__ = nreps;
            p.reserve(p_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < p_d_0_max__; ++d_0__) {
                if (jacobian__)
                    p.push_back(in__.simplex_constrain(notus, lp__));
                else
                    p.push_back(in__.simplex_constrain(notus));
            }
            // model body
            current_statement_begin__ = 19;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 20;
                lp_accum__.add(exponential_log(get_base1(theta, i, "theta", 1), 0.001));
                current_statement_begin__ = 21;
                lp_accum__.add(dirichlet_log(get_base1(pi, i, "pi", 1), rep_vector(0.0000001, notus)));
                current_statement_begin__ = 22;
                for (int j = get_base1(start, i, "start", 1); j <= get_base1(end, i, "end", 1); ++j) {
                    current_statement_begin__ = 23;
                    lp_accum__.add(dirichlet_log(get_base1(p, j, "p", 1), multiply(get_base1(theta, i, "theta", 1), get_base1(pi, i, "pi", 1))));
                    current_statement_begin__ = 24;
                    lp_accum__.add(multinomial_log(stan::model::rvalue(datamatrix, stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "datamatrix"), get_base1(p, j, "p", 1)));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("theta");
        names__.push_back("pi");
        names__.push_back("p");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(notus);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nreps);
        dims__.push_back(notus);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_dm_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> theta;
        size_t theta_d_0_max__ = N;
        theta.reserve(theta_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < theta_d_0_max__; ++d_0__) {
            theta.push_back(in__.scalar_lb_constrain(0));
        }
        size_t theta_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            vars__.push_back(theta[k_0__]);
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > pi;
        size_t pi_d_0_max__ = N;
        pi.reserve(pi_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < pi_d_0_max__; ++d_0__) {
            pi.push_back(in__.simplex_constrain(notus));
        }
        size_t pi_j_1_max__ = notus;
        size_t pi_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < pi_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < pi_k_0_max__; ++k_0__) {
                vars__.push_back(pi[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > p;
        size_t p_d_0_max__ = nreps;
        p.reserve(p_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < p_d_0_max__; ++d_0__) {
            p.push_back(in__.simplex_constrain(notus));
        }
        size_t p_j_1_max__ = notus;
        size_t p_k_0_max__ = nreps;
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                vars__.push_back(p[k_0__](j_1__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_dm";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t pi_j_1_max__ = notus;
        size_t pi_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < pi_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < pi_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pi" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t p_j_1_max__ = notus;
        size_t p_k_0_max__ = nreps;
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t pi_j_1_max__ = (notus - 1);
        size_t pi_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < pi_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < pi_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pi" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t p_j_1_max__ = (notus - 1);
        size_t p_k_0_max__ = nreps;
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_dm_namespace::model_dm stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
