% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_plotframework.R
\name{effectiveWeight}
\alias{effectiveWeight}
\title{Effective weights}
\usage{
effectiveWeight(COIN)
}
\arguments{
\item{COIN}{COIN object, or list with first entry is the indicator metadata, second entry is the aggregation metadata}
}
\value{
A list with effective weights, as well as a data frame with labels and parents for the
sunburst plot.
}
\description{
This calculates the effective weights of each element in the indicator hierarchy. This is
useful for understanding e.g. the true weight of each indicator in the framework and is also
used in \code{\link[=plotframework]{plotframework()}}.
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# get effective weights
effwts <- effectiveWeight(ASEM)

}
