% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{a_hmean}
\alias{a_hmean}
\title{Weighted harmonic mean}
\usage{
a_hmean(x, w = NULL)
}
\arguments{
\item{x}{A numeric vector of positive values.}

\item{w}{A vector of weights, which should have length equal to \code{length(x)}. Weights are relative
and will be re-scaled to sum to 1. If \code{w} is not specified, defaults to equal weights.}
}
\value{
Weighted harmonic mean, as a numeric value.
}
\description{
Weighted harmonic mean of a vector. \code{NA} are skipped by default.
}
\examples{
# a vector of values
x <- 1:10
# a vector of weights
w <- runif(10)
# weighted harmonic mean
a_hmean(x,w)

}
