% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinToolIn.R
\name{names_to_codes}
\alias{names_to_codes}
\title{Generate short codes from long names}
\usage{
names_to_codes(cvec, maxword = 2, maxlet = 4)
}
\arguments{
\item{cvec}{A character vector of names}

\item{maxword}{The maximum number of words to use in building a short name (default 2)}

\item{maxlet}{The number of letters to take from each word (default 4)}
}
\value{
A corresponding character vector, but with short codes, and no duplicates.
}
\description{
Given a character vector of long names (probably with spaces), generates short codes.
Intended for use when importing from the COIN Tool.
}
\examples{
# get names from example data
iNames <- ASEM_iMeta$iName

# convert to codes
names_to_codes(iNames)

}
\seealso{
\itemize{
\item \code{\link[=import_coin_tool]{import_coin_tool()}} Import data from the COIN Tool (Excel).
}
}
