% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{get_str_weak}
\alias{get_str_weak}
\title{Generate strengths and weaknesses for a specified unit}
\usage{
get_str_weak(
  coin,
  dset,
  usel = NULL,
  topN = 5,
  bottomN = 5,
  withcodes = TRUE,
  use_group = NULL,
  unq_discard = NULL,
  min_discard = TRUE,
  report_level = NULL,
  with_units = TRUE,
  adjust_direction = NULL
)
}
\arguments{
\item{coin}{A coin}

\item{dset}{The data set to extract indicator data from, to use as strengths and weaknesses.}

\item{usel}{A selected unit code}

\item{topN}{The top N indicators to report}

\item{bottomN}{The bottom N indicators to report}

\item{withcodes}{If \code{TRUE} (default), also includes a column of indicator codes. Setting to \code{FALSE} may be more useful
in generating reports, where codes are not helpful.}

\item{use_group}{An optional grouping variable to use for reporting
in-group ranks. Specifying this will report the ranks of the selected unit within the group of \code{use_group}
to which it belongs.}

\item{unq_discard}{Optional parameter for handling discrete indicators. Some indicators may be binary
variables of the type "yes = 1", "no = 0". These may be picked up as strengths or weaknesses, when they
may not be wanted to be highlighted, since e.g. maybe half of units will have a zero or a one. This argument
takes a number between 0 and 1 specifying a unique value threshold for ignoring indicators as strengths. E.g.
setting \code{prc_unq_discard = 0.2} will ensure that only indicators with at least 20\% unique values will be
highlighted as strengths or weaknesses. Set to \code{NULL} to disable (default).}

\item{min_discard}{If \code{TRUE} (default), discards any strengths which correspond to the minimum rank for the given
indicator. See details.}

\item{report_level}{Aggregation level to report parent codes from. For example, setting
\code{report_level = 2} (default) will add a column to the strengths and weaknesses tables which reports the aggregation
group from level 2, to which each reported indicator belongs.}

\item{with_units}{If \code{TRUE} (default), includes indicator units in output tables.}

\item{adjust_direction}{If \code{TRUE}, will adjust directions of indicators according to the "Direction" column
of \code{IndMeta}. By default, this is \code{TRUE} \emph{if} \code{dset = "Raw"}, and \code{FALSE} otherwise.}
}
\value{
A list containing a data frame \code{.$Strengths}, and a data frame \code{.$Weaknesses}.
Each data frame has columns with indicator code, name, rank and value (for the selected unit).
}
\description{
Generates a table of strengths and weaknesses for a selected unit, based on ranks, or ranks within
a specified grouping variable.
}
\details{
This currently only works at the indicator level. Indicators with \code{NA} values for the selected unit are ignored.
Strengths and weaknesses mean the \code{topN}-ranked indicators for the selected unit. Effectively, this takes the rank that the
selected unit has in each indicator, sorts the ranks, and takes the top N highest and lowest.

This function must be used with a little care: indicators should be adjusted for their directions before use,
otherwise a weakness might be counted as a strength, and vice versa. Use the \code{adjust_direction} parameter
to help here.

A further useful parameter is \code{unq_discard}, which also filters out any indicators with a low number of
unique values, based on a specified threshold. Also \code{min_discard} which filters out any indicators which
have the minimum rank.

The best way to use this function is to play around with the settings a little bit. The reason being that
in practice, indicators have very different distributions and these can sometimes lead to unexpected
outcomes. An example is if you have an indicator with 50\% zero values, and the rest non-zero (but unique).
Using the sport ranking system, all units with zero values will receive a rank which is equal to the number
of units divided by two. This then might be counted as a "strength" for some units with overall low scores.
But a zero value can hardly be called a strength. This is where the \code{min_discard} function can help out.

Problems such as these mainly arise when e.g. generating a large number of country profiles.

This function replaces the now-defunct \code{getStrengthNWeak()} from COINr < v1.0.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "new_coin", quietly = TRUE)

# get strengths and weaknesses for ESP
get_str_weak(coin, dset = "Raw", usel = "ESP")

}
