% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{readFMCAValues}
\alias{readFMCAValues}
\title{Read data from Fluorometric microculture cytotoxic assay (FMCA) data format and clean for outliers.}
\usage{
readFMCAValues(file, platetype, keyposition, selectionkey, platekey, wells,
  minThersholdForCVCal, minThersholdForCV, yConcentration, xConcentration)
}
\arguments{
\item{file}{Name of file to be read.}

\item{platetype}{384 etc.}

\item{keyposition}{Bar code position in the header row of each assayed plate.}

\item{selectionkey}{65000.}

\item{platekey}{Barcode.}

\item{wells}{Well ranges.}

\item{minThersholdForCVCal}{CV threshold for data outliers.}

\item{minThersholdForCV}{Threshold of survival values not used for CV calculations.}

\item{yConcentration}{Concentrations of y drug.}

\item{xConcentration}{Concentrations of x drug.}
}
\value{
Matrix of outlier removed replicated values.
}
\description{
Read data from Fluorometric microculture cytotoxic assay (FMCA) data format and clean for outliers.
}
\examples{
fl <- system.file("/raw/FluoOptima_384_2014-03-28test.txt", package="COMBIA")
wls <- list(c("A11:H11", "A12:H12","A1:H10",   "I11:P11", "I12:P12","I1:P10",
        "A23:H23", "A24:H24","A13:H22",   "I23:P23", "I24:P24","I13:P22")
                        )
pltype <- "384"
keypos <- 2
seleckey <- "65000"
barCode <- 7049
minThersholdForCVCal <- 0.1
minThersholdForCV <- 0.3
xConc <- c(0.00,  0.20,  0.39,0.78,  1.56,  3.12,  6.25, 12.50, 25.00, 50.00)
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
readFMCAValues(fl, pltype, keypos, seleckey, barCode,
              wls, minThersholdForCVCal, minThersholdForCV, xConc, yConc   )
}
\author{
Muhammad kashif
}

