% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{transform_params}
\alias{transform_params}
\title{Convert between parameterizations of the multivariate skew normal distribution.}
\usage{
transform_params(Sigma, alpha)
}
\arguments{
\item{Sigma}{A scale matrix.}

\item{alpha}{A vector for the skew parameter.}
}
\value{
A list:
\itemize{
\item \code{delta}: a reparameterized skewness vector, a transformed 
version of \code{alpha}.
\item \code{omega}: a diagonal matrix of the same dimensions as \code{Sigma}, 
the diagonal elements are the square roots of the diagonal elements of \code{Sigma}.
\item \code{psi}: another reparameterized skewness vector, utilized in the sampler.
\item \code{G}: a reparameterized version of \code{Sigma}, utilized in the sampler.
}
}
\description{
Convert between parameterizations of the multivariate skew normal distribution.
}
\examples{
library(COMIX)
# Scale and skew parameters:
Sigma <- matrix(0.5, nrow = 4, ncol = 4) + diag(0.5, nrow = 4)
alpha <- c(0, 0, 0, 5)
transformed_parameters <- transform_params(Sigma, alpha)
}
