% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SampleOverlapMatrix}
\alias{SampleOverlapMatrix}
\title{An example data of sample-overlap matrices.}
\format{A list consisting of three integer square matrices (each of dimension 5 by 5): 
\describe{
 \item{n11}{number of cases shared between all possible pairs of diseases.}
 \item{n00}{number of controls shared between all possible pairs of diseases.}
 \item{n10}{number of subjects who are case for one disease and control for another disease.}
}}
\usage{
data(SampleOverlapMatrix)
}
\description{
An example data of sample-overlap matrices for five different diseases in the Kaiser 
GERA cohort (a real data).
SampleOverlapMatrix is a list that contains an example of the sample overlap matrices
 for five different diseases in the Kaiser GERA cohort. SampleOverlapMatrix$n11
  provides the number of cases shared between all possible pairs of diseases.
   SampleOverlapMatrix$n00 provides the number of controls shared between all possible
    pairs of diseases. SampleOverlapMatrix$n10 provides the number of subjects who
     are case for one disease and control for another disease.
}
\examples{
data(SampleOverlapMatrix)
n11 <- SampleOverlapMatrix$n11
n11
n00 <- SampleOverlapMatrix$n00
n00
n10 <- SampleOverlapMatrix$n10
n10
\donttest{estimate_corln(n11,n00,n10)}
}
\keyword{datasets}
