% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_cate.R
\name{estimate_cate}
\alias{estimate_cate}
\title{Estimate the Conditional Average Treatment Effect}
\usage{
estimate_cate(rules_matrix, rules_explicit, ite, t_pvalue)
}
\arguments{
\item{rules_matrix}{A rules matrix,}

\item{rules_explicit}{A list of select rules in terms of coviariate names.}

\item{ite}{The estimated ITEs.}

\item{t_pvalue}{The threshold to define statistically significant rules
(filter only rules with p-value <= t_pvalue).}
}
\value{
A dataframe summarizing the CATE linear decomposition:
\itemize{
\item 'Rule': rule name,
\item 'Estimate': linear contribution to CATE,
\item 'CI_lower`: lower bound 95\% confidence interval on the estimate,
\item 'CI_upper`: upper bound 95\% confidence interval on the estimate,
\item \code{P-Value}: p-value (from Z-test).
}
}
\description{
Estimates the Conditional Average Treatment Effect (CATE) by
linearly modeling the Individual Treatment Effect by a set of rules.
}
\keyword{internal}
