% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeriodAccumulation.R
\name{PeriodAccumulation}
\alias{PeriodAccumulation}
\title{Period Accumulation on multidimensional array objects}
\usage{
PeriodAccumulation(
  data,
  dates = NULL,
  start = NULL,
  end = NULL,
  time_dim = "time",
  rollwidth = NULL,
  sdate_dim = "sdate",
  frequency = "monthly",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{A multidimensional array with named dimensions.}

\item{dates}{A multidimensional array of dates with named dimensions matching 
the temporal dimensions on parameter 'data'. By default it is NULL, to  
select aperiod this parameter must be provided.}

\item{start}{An optional parameter to defined the initial date of the period 
to select from the data by providing a list of two elements: the initial 
date of the period and the initial month of the period. By default it is set
to NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to defined the final date of the period to 
select from the data by providing a list of two elements: the final day of 
the period and the final month of the period. By default it is set to NULL 
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the dimension to 
compute the indicator. By default, it is set to 'time'.}

\item{rollwidth}{An optional parameter to indicate the number of time 
steps the rolling sum is applied to. If it is positive, the rolling sum is 
applied backwards 'time_dim', if it is negative, it will be forward it. When 
this parameter is NULL, the sum is applied over all 'time_dim', in a 
specified period. It is NULL by default.}

\item{sdate_dim}{(Only needed when rollwidth is used). A character string 
indicating the name of the start date dimension to compute the rolling 
accumulation. By default, it is set to 'sdate'.}

\item{frequency}{(Only needed when rollwidth is used). A character string 
indicating the time frequency of the data to apply the rolling accumulation.  
It can be 'daily' or 'monthly'. If it is set to 'monthly', values from
continuous months will be accumulated; if it is 'daliy', values from 
continuous days will be accumulated. It is set to 'monthly' by default.}

\item{na.rm}{A logical value indicating whether to ignore NA values (TRUE) or 
not (FALSE).}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
A multidimensional array with named dimensions containing the 
accumulated data in the element \code{data}. If parameter 'rollwidth' is 
not used, it will have the dimensions of the input 'data' except the dimension 
where the accumulation has been computed (specified with 'time_dim'). If 
'rollwidth' is used, it will be of same dimensions as input data.
}
\description{
Period Accumulation computes the sum (accumulation) of a given variable in a 
period. Providing precipitation data, two agriculture indices can be obtained 
by using this function:
\itemize{
 \item{'SprR', Spring Total Precipitation: The total precipitation from 
       April 21th to June 21st.}
 \item{'HarR', Harvest Total Precipitation: The total precipitation from 
       August 21st to October 21st.}
}
}
\details{
There are two possible ways of performing the accumulation. The default one 
is by accumulating a variable over a dimension specified with 'time_dim'. To 
chose a specific time period, 'start' and 'end' must be used. The other method 
is by using 'rollwidth' parameter. When this parameter is a positive integer, 
the cumulative backward sum is applied to the time dimension. If it is 
negative, the rolling sum is applied backwards.
}
\examples{
exp <- array(rnorm(216)*200, dim = c(dataset = 1, member = 2, sdate = 3, 
            ftime = 9, lat = 2, lon = 2))
TP <- PeriodAccumulation(exp, time_dim = 'ftime')
data <- array(rnorm(5 * 3 * 214 * 2),
             c(memb = 5, sdate = 3, ftime = 214, lon = 2)) 
Dates <- c(seq(as.Date("01-05-2000", format = "\%d-\%m-\%Y"), 
              as.Date("30-11-2000", format = "\%d-\%m-\%Y"), by = 'day'),
          seq(as.Date("01-05-2001", format = "\%d-\%m-\%Y"), 
              as.Date("30-11-2001", format = "\%d-\%m-\%Y"), by = 'day'),
          seq(as.Date("01-05-2002", format = "\%d-\%m-\%Y"), 
              as.Date("30-11-2002", format = "\%d-\%m-\%Y"), by = 'day'))
dim(Dates) <- c(sdate = 3, ftime = 214)
SprR <- PeriodAccumulation(data, dates = Dates, start = list(21, 4), 
                          end = list(21, 6), time_dim = 'ftime')
HarR <- PeriodAccumulation(data, dates = Dates, start = list(21, 8), 
                          end = list(21, 10), time_dim = 'ftime')

}
