% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_BEI_Weighting.R
\name{BEI_EMWeighting}
\alias{BEI_EMWeighting}
\title{Computing the weighted ensemble means for SFSs.}
\usage{
BEI_EMWeighting(var_exp, aweights, time_dim_name = "time", memb_dim = "member")
}
\arguments{
\item{var_exp}{Variable (e.g. precipitation, temperature, NAO index)
array from a SFS with at least dimensions (time, member) for a spatially 
aggregated variable or dimensions (time, member, lat, lon) for a spatial 
variable, as 'time' the spatial dimension by default.}

\item{aweights}{Normalized weights array with at least dimensions 
(time, member), when 'time' is the temporal dimension as default.}

\item{time_dim_name}{A character string indicating the name of the 
temporal dimension, by default 'time'.}

\item{memb_dim}{A character string indicating the name of the 
member dimension, by default 'member'.}
}
\value{
BEI_EMWeighting() returns an array with at least one or three 
dimensions depending if the variable is spatially aggregated variable 
(as e.g. NAO index)(time) or it is spatial variable (as e.g. precipitation 
or temperature) (time, lat, lon), containing the ensemble means computing
with weighted members.
}
\description{
This function implements the computation to obtain the weighted
ensemble means for SFSs using a normalized weights array,
}
\examples{
# Example 1 
var_exp <- 1 : (2 * 3 * 4)
dim(var_exp) <- c(time = 2, dataset = 3, member = 4)
aweights <- runif(24, min = 0.001, max = 0.999)
dim(aweights) <- c(time = 2, dataset = 3, member = 4)
res <- BEI_EMWeighting(var_exp, aweights)

# Example 2 
var_exp <- 1 : (2 * 4 * 2 * 3)
dim(var_exp) <- c(time = 2, member = 4, lat = 2, lon = 3)
aweights <- c(0.2, 0.1, 0.3, 0.4, 0.1, 0.2, 0.4, 0.3)
dim(aweights) <- c(time = 2, member = 4)
res <- BEI_EMWeighting(var_exp, aweights)

}
\references{
Regionally improved seasonal forecast of precipitation through Best
estimation of winter NAO, Sanchez-Garcia, E. et al.,
Adv. Sci. Res., 16, 165174, 2019, \doi{10.5194/asr-16-165-2019}
}
\author{
Eroteida Sanchez-Garcia - AEMET, \email{esanchezg@aemet.es}
}
