% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{lambda_min}
\alias{lambda_min}
\title{Minimum Eigenvalue}
\usage{
lambda_min(A)
}
\arguments{
\item{A}{An \linkS4class{Expression} or matrix.}
}
\value{
An \linkS4class{Expression} representing the minimum eigenvalue of the input.
}
\description{
The minimum eigenvalue of a matrix, \eqn{\lambda_{\min}(A)}.
}
\examples{
A <- Variable(2,2)
val <- cbind(c(5,7), c(7,-3))
prob <- Problem(Maximize(lambda_min(A)), list(A == val))
result <- solve(prob)
result$value
result$getValue(A)
}
