% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conic_solvers.R
\docType{class}
\name{MOSEK-class}
\alias{MOSEK-class}
\alias{MOSEK}
\alias{mip_capable,MOSEK-method}
\alias{import_solver,MOSEK-method}
\alias{name,MOSEK-method}
\alias{accepts,MOSEK,Problem-method}
\alias{block_format,MOSEK-method}
\alias{perform,MOSEK,Problem-method}
\alias{solve_via_data,MOSEK-method}
\alias{invert,MOSEK,ANY,ANY-method}
\title{An interface for the MOSEK solver.}
\usage{
MOSEK()

\S4method{mip_capable}{MOSEK}(solver)

\S4method{import_solver}{MOSEK}(solver)

\S4method{name}{MOSEK}(x)

\S4method{accepts}{MOSEK,Problem}(object, problem)

\S4method{block_format}{MOSEK}(object, problem, constraints, exp_cone_order = NA)

\S4method{perform}{MOSEK,Problem}(object, problem)

\S4method{solve_via_data}{MOSEK}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache
)

\S4method{invert}{MOSEK,ANY,ANY}(object, solution, inverse_data)
}
\arguments{
\item{solver, object, x}{A \linkS4class{MOSEK} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{constraints}{A list of \linkS4class{Constraint} objects for which coefficient
andd offset data ("G", "h" respectively) is needed}

\item{exp_cone_order}{A parameter that is only used when a \linkS4class{Constraint} object
describes membership in the exponential cone.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance.}

\item{reltol}{The relative tolerance.}

\item{abstol}{The absolute tolerance.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}

\item{solution}{The raw solution returned by the solver.}

\item{inverse_data}{A list containing data necessary for the inversion.}
}
\description{
An interface for the MOSEK solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable}: Can the solver handle mixed-integer programs?

\item \code{import_solver}: Imports the solver.

\item \code{name}: Returns the name of the solver.

\item \code{accepts}: Can MOSEK solve the problem?

\item \code{block_format}: Returns a large matrix "coeff" and a vector of constants "offset" such
that every \linkS4class{Constraint} in "constraints" holds at z in R^n iff
"coeff" * z <=_K offset", where K is a product of cones supported by MOSEK
and CVXR (zero cone, nonnegative orthant, second order cone, exponential cone). The
nature of K is inferred later by accessing the data in "lengths" and "ids".

\item \code{perform}: Returns a new problem and data for inverting the new solution.

\item \code{solve_via_data}: Solve a problem represented by data returned from apply.

\item \code{invert}: Returns the solution to the original problem given the inverse_data.
}}

