% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\docType{methods}
\name{is_dgp}
\alias{is_dgp}
\title{DGP Compliance}
\usage{
is_dgp(object)
}
\arguments{
\item{object}{A \linkS4class{Problem} or \linkS4class{Expression} object.}
}
\value{
A logical value indicating whether the problem or expression is DCP compliant, i.e. no unknown curvatures.
}
\description{
Determine if a problem or expression complies with the disciplined geometric programming rules.
}
\examples{
x <- Variable(pos = TRUE)
y <- Variable(pos = TRUE)
prob <- Problem(Minimize(x*y), list(x >= 5, y >= 5))
is_dgp(prob)
solve(prob, gp = TRUE)
}
