% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{coronary_death_df}
\alias{coronary_death_df}
\title{High vs Moderate Statins for MI Prevention}
\format{
A data frame with 4 observations and 16 variables:
\describe{
\item{trial}{Trial identifier (character vector)}
\item{pop}{Patient population description (character vector)}
\item{nt}{Number of patients in treatment group (integer vector)}
\item{nc}{Number of patients in control group (integer vector)}
\item{ep1t}{Endpoint 1 events in treatment group (integer vector)}
\item{ep1c}{Endpoint 1 events in control group (integer vector)}
\item{ep2t}{Endpoint 2 events in treatment group (integer vector)}
\item{ep2c}{Endpoint 2 events in control group (integer vector)}
\item{ep3t}{Endpoint 3 events in treatment group (integer vector)}
\item{ep3c}{Endpoint 3 events in control group (integer vector)}
\item{ep4t}{Endpoint 4 events in treatment group (integer vector)}
\item{ep4c}{Endpoint 4 events in control group (integer vector)}
\item{ep5t}{Endpoint 5 events in treatment group (integer vector)}
\item{ep5c}{Endpoint 5 events in control group (integer vector)}
\item{ep6t}{Endpoint 6 events in treatment group (integer vector)}
\item{ep6c}{Endpoint 6 events in control group (integer vector)}
}
}
\source{
Data taken from the metadat package version 1.2-0
}
\usage{
data(coronary_death_df)
}
\description{
This dataset, coronary_death_df, is a data frame containing information from 4 clinical trials
comparing intensive (high dose) versus moderate (standard dose) statin therapy for preventing
coronary death or myocardial infarction. It includes data on treatment outcomes across multiple
endpoints.
}
\details{
The dataset name has been kept as 'coronary_death_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a standard data frame. The original content has not been modified
in any way.
}
