% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\docType{methods}
\name{transform}
\alias{LabelEncoder.Character,character-method}
\alias{LabelEncoder.Numeric,numeric-method}
\alias{transform}
\alias{transform,}
\alias{transform,LabelEncoder.Character-method}
\alias{transform,LabelEncoder.Factor,factor-method}
\alias{transform,LabelEncoder.Factor-method}
\alias{transform,LabelEncoder.Numeric-method}
\alias{transform,OneHotEncoder,Any,logical-method}
\alias{transform,OneHotEncoder-method}
\title{transform
transforms a new data set using the fitted encoder}
\usage{
transform(enc, ...)

\S4method{transform}{LabelEncoder.Numeric}(enc, y)

\S4method{transform}{LabelEncoder.Character}(enc, y)

\S4method{transform}{LabelEncoder.Factor}(enc, y)

\S4method{transform}{OneHotEncoder}(enc, X, sparse = TRUE,
  new.feature.error = TRUE)
}
\arguments{
\item{enc}{A fitted encoder, i.e., LabelEncoder or OneHotEncoder}

\item{...}{Additional argument list}

\item{y}{A vector of character, factor or numeric values}

\item{X}{A data.frame or matrix}

\item{sparse}{If TRUE then return a sparse matrix, default = TRUE}

\item{new.feature.error}{If TRUE then throw an error for new feature values; otherwise the new feature values are ignored, default = TRUE}
}
\value{
If enc is an OneHotEncoder, the returned value is a sparse or dense matrix. If enc is a LabelEncoder, the returned value is a vector.
}
\description{
transform
transforms a new data set using the fitted encoder
}
\examples{
# matrix X
X1 <- matrix(c(0, 1, 0, 1, 0, 1, 2, 0, 3, 0, 1, 2),c(4,3),byrow=FALSE)
oenc <- OneHotEncoder.fit(X1)
z <- transform(oenc,X1,sparse=TRUE)
# return a sparse matrix
print(z)

# data.frame X
X2 <- cbind(data.frame(X1),X4=c('a','b','d',NA),X5=factor(c(1,2,3,1)))
oenc <- OneHotEncoder.fit(X2)
z <- transform(oenc,X2,sparse=FALSE)
# return a dense matrix
print(z)

# factor vector y
y <- factor(c('a','d','e',NA),exclude=NULL)
lenc <- LabelEncoder.fit(y)
# new values are transformed to NA
z <- transform(lenc,factor(c('d','d',NA,'f')))
print(z)

# character vector y
y <- c('a','d','e',NA)
lenc <- LabelEncoder.fit(y)
# new values are transformed to NA
z <- transform(lenc,c('d','d',NA,'f'))
print(z)

# numeric vector y
set.seed(123)
y <- sample(c(1:10,NA),5)
lenc <- LabelEncoder.fit(y)
# new values are transformed to NA
z <-transform(lenc,sample(c(1:10,NA),5))
print(z)
}

