% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colMapping.R
\name{colMapping}
\alias{colMapping}
\title{Add column mappings}
\usage{
colMapping(.Object, mappings = NULL, ...)
}
\arguments{
\item{.Object}{Model (\code{NlmePmlModel}) object}

\item{mappings}{Named character vector specifying valid column names in the input data.
Character vector names must be valid model variable names contained
in \code{modelVariableNames(model)}.}

\item{...}{optional pairs ModelTerm = ColumnName or ModelTerm = "ColumnName".
Has higher precedence than \code{mappings} if some ModelTerm is mapped twice in
\code{mappings} and in \code{...}. For multiple mapping, i.e. id mapping,
a vector should be provided with the names of columns. See example below.}
}
\value{
modified \code{NlmePmlModel} object
}
\description{
Piping compatible function for \code{modelColumnMapping} used to add column mappings from input data to model object
}
\examples{
pkData$id2 <- pkData$Subject
model <- pkmodel(columnMap = FALSE,
                 data = pkData)

modelvar <- unlist(modelVariableNames(model))

colnames <- c("Subject", "Act_Time", "Amount", "Conc")
names(colnames) <- modelvar
# will map subject directly
colnames <- colnames[-c(1)]

model <- colMapping(model, colnames, id = c(Subject, id2))
# also possible:
model <- colMapping(model, colnames, id = c("Subject", "id2"))
# not recommended since only not quoted names are identified
# if both types are provided:
model <- colMapping(model, colnames, id = c("Subject", id2))

}
\seealso{
\code{\link{dataMapping}} \code{\link{modelVariableNames}}
}
